/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSStyleSheet;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.om.RuleParseException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class DefaultSheetErrorHandler
implements SheetErrorHandler,
Serializable {
    private static final long serialVersionUID = 2L;
    private final CSSStyleSheet<?> sheet;
    private LinkedList<String> unknownRules = null;
    private LinkedList<String> ignoredImports = null;
    private LinkedList<RuleParseException> ruleParseErrors = null;
    private LinkedList<MediaQueryList> badMediaLists = null;
    private LinkedList<String> badAtRules = null;
    private LinkedList<String> badConditions = null;
    private List<CSSRule> ruleList = null;
    private List<CSSParseException> sacWarnings = null;
    private List<CSSParseException> sacErrors = null;
    private boolean sacWarningMergedState = false;
    private boolean sacErrorMergedState = false;
    private boolean omWarningMergedState = false;
    private boolean omErrorMergedState = false;

    public DefaultSheetErrorHandler(CSSStyleSheet<? extends CSSRule> sheet) {
        this.sheet = sheet;
    }

    @Override
    public void badAtRule(DOMException e, String atRule) {
        if (this.badAtRules == null) {
            this.badAtRules = new LinkedList();
        }
        this.badAtRules.add(atRule);
    }

    @Override
    public void badMediaList(MediaQueryList media) {
        if (this.badMediaLists == null) {
            this.badMediaLists = new LinkedList();
        }
        this.badMediaLists.add(media);
    }

    @Override
    public void handleSacError(CSSParseException exception) {
        if (this.sacErrors == null) {
            this.sacErrors = new LinkedList<CSSParseException>();
            this.ruleList = new LinkedList<CSSRule>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(null);
    }

    @Override
    public void handleSacWarning(CSSParseException exception) {
        if (this.sacWarnings == null) {
            this.sacWarnings = new LinkedList<CSSParseException>();
        }
        this.sacWarnings.add(exception);
    }

    @Override
    public boolean hasOMErrors() {
        return this.omErrorMergedState || this.unknownRules != null || this.ignoredImports != null || this.ruleParseErrors != null || this.badMediaLists != null || this.badAtRules != null || this.badConditions != null;
    }

    @Override
    public boolean hasOMWarnings() {
        return this.omWarningMergedState;
    }

    @Override
    public boolean hasSacErrors() {
        return this.sacErrorMergedState || this.sacErrors != null;
    }

    @Override
    public boolean hasSacWarnings() {
        return this.sacWarningMergedState || this.sacWarnings != null;
    }

    @Override
    public void ignoredImport(String uri) {
        if (this.ignoredImports == null) {
            this.ignoredImports = new LinkedList();
        }
        this.ignoredImports.add(uri);
    }

    @Override
    public void ruleParseError(CSSRule rule, CSSParseException ex) {
        if (this.ruleParseErrors == null) {
            this.ruleParseErrors = new LinkedList();
        }
        RuleParseException rpe = new RuleParseException(ex, rule);
        this.ruleParseErrors.add(rpe);
    }

    @Override
    public void ruleParseWarning(CSSRule rule, CSSParseException ex) {
    }

    @Override
    public void conditionalRuleError(BooleanCondition condition, String message) {
        if (this.badConditions == null) {
            this.badConditions = new LinkedList();
        }
        this.badConditions.add(message);
    }

    @Override
    public void fontFormatError(CSSFontFaceRule rule, Exception exception) {
    }

    @Override
    public void unknownRule(String rule) {
        if (this.unknownRules == null) {
            this.unknownRules = new LinkedList();
        }
        this.unknownRules.add(rule);
    }

    @Override
    public void mapError(CSSParseException exception, CSSRule rule) {
        if (this.ruleList == null) {
            this.ruleList = new LinkedList<CSSRule>();
            this.sacErrors = new LinkedList<CSSParseException>();
        }
        this.sacErrors.add(exception);
        this.ruleList.add(rule);
    }

    public LinkedList<String> getBadAtRules() {
        return this.badAtRules;
    }

    @Deprecated
    public LinkedList<String> getBadInlineStyles() {
        return null;
    }

    public LinkedList<String> getConditionErrors() {
        return this.badConditions;
    }

    public LinkedList<MediaQueryList> getBadMediaLists() {
        return this.badMediaLists;
    }

    public LinkedList<String> getIgnoredImports() {
        return this.ignoredImports;
    }

    public CSSRule getRuleAtError(int index) {
        return this.ruleList == null ? null : this.ruleList.get(index);
    }

    public LinkedList<RuleParseException> getRuleParseErrors() {
        return this.ruleParseErrors;
    }

    public List<CSSParseException> getSacErrors() {
        return this.sacErrors;
    }

    public List<CSSParseException> getSacWarnings() {
        return this.sacWarnings;
    }

    public LinkedList<String> getUnknownRules() {
        return this.unknownRules;
    }

    @Override
    public void mergeState(SheetErrorHandler other) {
        this.sacWarningMergedState = this.sacWarningMergedState || other.hasSacWarnings();
        this.sacErrorMergedState = this.sacErrorMergedState || other.hasSacErrors();
        this.omErrorMergedState = this.omErrorMergedState || other.hasOMErrors();
        this.omWarningMergedState = this.omWarningMergedState || other.hasOMWarnings();
    }

    @Override
    public void reset() {
        this.ruleList = null;
        this.sacErrors = null;
        this.sacWarnings = null;
        this.sacErrorMergedState = false;
        this.sacWarningMergedState = false;
        this.omErrorMergedState = false;
        this.unknownRules = null;
        this.ignoredImports = null;
        this.ruleParseErrors = null;
        this.badMediaLists = null;
        this.badAtRules = null;
        this.badConditions = null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this.hasSacErrors()) {
            buf.append("NSAC Errors:");
            if (this.sacErrors != null) {
                buf.append('\n');
                for (int i = 0; i < this.sacErrors.size(); ++i) {
                    CSSParseException ex = this.sacErrors.get(i);
                    CSSRule rule = this.ruleList.get(i);
                    buf.append('[').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber()).append("] ").append(ex.getMessage());
                    if (rule != null) {
                        buf.append(" --> ").append(rule.getCssText());
                    }
                    buf.append('\n');
                }
            } else {
                buf.append(" only merged.\n");
            }
        } else {
            buf.append("No NSAC errors.\n");
        }
        if (this.sacWarnings != null) {
            buf.append("NSAC Warnings:");
            Iterator<CSSParseException> it = this.sacWarnings.iterator();
            while (it.hasNext()) {
                buf.append(' ').append(it.next().getMessage());
            }
        } else {
            buf.append("No NSAC warnings.\n");
        }
        return buf.toString();
    }

    @Override
    public void sacMalfunction(String message) {
        String text = "unknown";
        Node owner = this.sheet.getOwnerNode();
        if (owner != null && owner.getNodeType() == 1 && "style".equalsIgnoreCase(((CSSElement)owner).getTagName())) {
            text = owner.toString();
        } else {
            String uri = this.sheet.getHref();
            if (uri != null) {
                text = "at " + uri;
            }
        }
        message = "NSAC malfuntion in sheet " + text + ": " + message;
        throw new IllegalStateException(message);
    }
}

