/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped.panel;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.BackgroundPainter;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.panel.BaseContainer;
import net.infonode.gui.shaped.border.ShapedBorder;
import net.infonode.util.Direction;

public class ShapedPanel
extends BaseContainer
implements BackgroundPainter {
    private Direction direction = Direction.RIGHT;
    private boolean horizontalFlip;
    private boolean verticalFlip;
    private boolean clipChildren;
    private ComponentPainter painter;
    private ShapedBorder shapedBorder;
    private Insets shapedInsets;

    public ShapedPanel() {
    }

    public ShapedPanel(LayoutManager l) {
        super(l);
    }

    public ShapedPanel(ComponentPainter painter) {
        this();
        this.painter = painter;
    }

    public ShapedPanel(ComponentPainter painter, Border border) {
        this(painter);
        this.setBorder(border);
    }

    public ShapedPanel(Component component) {
        this();
        this.add(component, "Center");
    }

    public Shape getShape() {
        ShapedBorder b = this.getShapedBorder();
        return b == null ? null : b.getShape(this, this.shapedInsets.left, this.shapedInsets.top, this.getWidth() - this.shapedInsets.left - this.shapedInsets.right, this.getHeight() - this.shapedInsets.top - this.shapedInsets.bottom);
    }

    @Override
    public ComponentPainter getComponentPainter() {
        return this.painter;
    }

    public void setComponentPainter(ComponentPainter painter) {
        if (this.painter != painter) {
            this.painter = painter;
            this.repaint();
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isHorizontalFlip() {
        return this.horizontalFlip;
    }

    public void setHorizontalFlip(boolean horizontalFlip) {
        if (this.horizontalFlip != horizontalFlip) {
            this.horizontalFlip = horizontalFlip;
            this.revalidate();
        }
    }

    public boolean isVerticalFlip() {
        return this.verticalFlip;
    }

    public void setVerticalFlip(boolean verticalFlip) {
        if (this.verticalFlip != verticalFlip) {
            this.verticalFlip = verticalFlip;
            this.revalidate();
        }
    }

    public void setDirection(Direction direction) {
        if (this.direction != direction) {
            this.direction = direction;
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isClipChildren() {
        return this.clipChildren;
    }

    public void setClipChildren(boolean clipChildren) {
        this.clipChildren = clipChildren;
    }

    public ShapedBorder getShapedBorder() {
        return this.shapedBorder;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.shapedBorder = null;
        this.findShapedBorder(this.getBorder(), new Insets(0, 0, 0, 0));
    }

    @Override
    protected void paintChildren(Graphics g) {
        Shape shape;
        if (this.clipChildren && (shape = this.getShape()) != null) {
            Graphics2D g2 = (Graphics2D)g;
            Shape clip = g2.getClip();
            g2.clip(shape);
            super.paintChildren(g);
            g2.setClip(clip);
            return;
        }
        super.paintChildren(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.painter != null) {
            Shape shape = this.getShape();
            if (shape != null) {
                Shape clip = g.getClip();
                g.clipRect(this.shapedInsets.left, this.shapedInsets.top, this.getWidth() - this.shapedInsets.left - this.shapedInsets.right, this.getHeight() - this.shapedInsets.top - this.shapedInsets.bottom);
                ((Graphics2D)g).clip(shape);
                this.painter.paint(this, g, 0, 0, this.getWidth(), this.getHeight(), this.direction, this.horizontalFlip, this.verticalFlip);
                g.setClip(clip);
            } else {
                this.painter.paint(this, g, 0, 0, this.getWidth(), this.getHeight(), this.direction, this.horizontalFlip, this.verticalFlip);
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            return false;
        }
        Shape shape = this.getShape();
        return shape == null ? super.contains(x, y) : shape.contains(x, y);
    }

    @Override
    public boolean inside(int x, int y) {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            return false;
        }
        Shape shape = this.getShape();
        return shape == null ? super.inside(x, y) : shape.contains(x, y);
    }

    private boolean findShapedBorder(Border border, Insets i) {
        if (border == null) {
            return false;
        }
        if (border instanceof ShapedBorder) {
            this.shapedBorder = (ShapedBorder)border;
            this.shapedInsets = i;
            return true;
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder c = (CompoundBorder)border;
            if (this.findShapedBorder(c.getOutsideBorder(), i)) {
                return true;
            }
            return this.findShapedBorder(c.getInsideBorder(), InsetsUtil.add(c.getOutsideBorder().getBorderInsets(this), i));
        }
        return false;
    }
}

