﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53/Route53_EXPORTS.h>
#include <aws/route53/model/ResourceTagSet.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Route53 {
namespace Model {
/**
 * <p>A complex type that contains information about the health checks or hosted
 * zones for which you want to list tags.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResourceResponse">AWS
 * API Reference</a></p>
 */
class ListTagsForResourceResult {
 public:
  AWS_ROUTE53_API ListTagsForResourceResult() = default;
  AWS_ROUTE53_API ListTagsForResourceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_ROUTE53_API ListTagsForResourceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A <code>ResourceTagSet</code> containing tags associated with the specified
   * resource.</p>
   */
  inline const ResourceTagSet& GetResourceTagSet() const { return m_resourceTagSet; }
  template <typename ResourceTagSetT = ResourceTagSet>
  void SetResourceTagSet(ResourceTagSetT&& value) {
    m_resourceTagSetHasBeenSet = true;
    m_resourceTagSet = std::forward<ResourceTagSetT>(value);
  }
  template <typename ResourceTagSetT = ResourceTagSet>
  ListTagsForResourceResult& WithResourceTagSet(ResourceTagSetT&& value) {
    SetResourceTagSet(std::forward<ResourceTagSetT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTagsForResourceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ResourceTagSet m_resourceTagSet;

  Aws::String m_requestId;
  bool m_resourceTagSetHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53
}  // namespace Aws
