﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mq/MQ_EXPORTS.h>
#include <aws/mq/model/ConfigurationRevision.h>
#include <aws/mq/model/SanitizationWarning.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MQ {
namespace Model {
class UpdateConfigurationResult {
 public:
  AWS_MQ_API UpdateConfigurationResult() = default;
  AWS_MQ_API UpdateConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MQ_API UpdateConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the configuration.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  UpdateConfigurationResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Required. The date and time of the configuration.</p>
   */
  inline const Aws::Utils::DateTime& GetCreated() const { return m_created; }
  template <typename CreatedT = Aws::Utils::DateTime>
  void SetCreated(CreatedT&& value) {
    m_createdHasBeenSet = true;
    m_created = std::forward<CreatedT>(value);
  }
  template <typename CreatedT = Aws::Utils::DateTime>
  UpdateConfigurationResult& WithCreated(CreatedT&& value) {
    SetCreated(std::forward<CreatedT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID that Amazon MQ generates for the configuration.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  UpdateConfigurationResult& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest revision of the configuration.</p>
   */
  inline const ConfigurationRevision& GetLatestRevision() const { return m_latestRevision; }
  template <typename LatestRevisionT = ConfigurationRevision>
  void SetLatestRevision(LatestRevisionT&& value) {
    m_latestRevisionHasBeenSet = true;
    m_latestRevision = std::forward<LatestRevisionT>(value);
  }
  template <typename LatestRevisionT = ConfigurationRevision>
  UpdateConfigurationResult& WithLatestRevision(LatestRevisionT&& value) {
    SetLatestRevision(std::forward<LatestRevisionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configuration. This value can contain only alphanumeric
   * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must
   * be 1-150 characters long.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateConfigurationResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of the first 20 warnings about the configuration elements or
   * attributes that were sanitized.</p>
   */
  inline const Aws::Vector<SanitizationWarning>& GetWarnings() const { return m_warnings; }
  template <typename WarningsT = Aws::Vector<SanitizationWarning>>
  void SetWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings = std::forward<WarningsT>(value);
  }
  template <typename WarningsT = Aws::Vector<SanitizationWarning>>
  UpdateConfigurationResult& WithWarnings(WarningsT&& value) {
    SetWarnings(std::forward<WarningsT>(value));
    return *this;
  }
  template <typename WarningsT = SanitizationWarning>
  UpdateConfigurationResult& AddWarnings(WarningsT&& value) {
    m_warningsHasBeenSet = true;
    m_warnings.emplace_back(std::forward<WarningsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;

  Aws::Utils::DateTime m_created{};

  Aws::String m_id;

  ConfigurationRevision m_latestRevision;

  Aws::String m_name;

  Aws::Vector<SanitizationWarning> m_warnings;

  Aws::String m_requestId;
  bool m_arnHasBeenSet = false;
  bool m_createdHasBeenSet = false;
  bool m_idHasBeenSet = false;
  bool m_latestRevisionHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_warningsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
