/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;
import java.util.Iterator;

public final class ReferenceStack<T>
implements Iterable<T> {
    private static final int INITIAL_CAPACITY = 64;
    private final IntegerStack freeList;
    private Object[] nativeObjectWrapperList = new Object[64];

    @CompilerDirectives.TruffleBoundary
    public ReferenceStack() {
        this.freeList = new IntegerStack(64);
        this.freeList.addToFreeList(0, 64);
    }

    @CompilerDirectives.TruffleBoundary
    private void enlargeNativeReferenceList() {
        int oldSize = this.nativeObjectWrapperList.length;
        int newSize = oldSize * 2;
        this.nativeObjectWrapperList = Arrays.copyOf(this.nativeObjectWrapperList, newSize);
        this.freeList.addToFreeList(oldSize, newSize);
    }

    public T get(int idx) {
        if (0 <= idx && idx < this.nativeObjectWrapperList.length) {
            return (T)this.nativeObjectWrapperList[idx];
        }
        assert (false) : "incorrect reference ID";
        return null;
    }

    public T remove(int idx) {
        assert (0 <= idx && idx < this.nativeObjectWrapperList.length);
        Object ref = this.nativeObjectWrapperList[idx];
        this.nativeObjectWrapperList[idx] = null;
        this.freeList.push(idx);
        return (T)ref;
    }

    public int reserve() {
        int nativeRefID = this.freeList.pop();
        if (nativeRefID == -1) {
            this.enlargeNativeReferenceList();
            nativeRefID = this.freeList.pop();
        }
        assert (nativeRefID != -1);
        return nativeRefID;
    }

    public void commit(int idx, T nativeObjectReference) {
        assert (0 <= idx && idx < this.nativeObjectWrapperList.length);
        assert (this.nativeObjectWrapperList[idx] == null) : "cannot overwrite an allocated native object reference slot";
        this.nativeObjectWrapperList[idx] = nativeObjectReference;
    }

    public T resurrect(int idx, T nativeObjectReference) {
        assert (0 <= idx && idx < this.nativeObjectWrapperList.length);
        Object old = this.nativeObjectWrapperList[idx];
        this.nativeObjectWrapperList[idx] = nativeObjectReference;
        return (T)old;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.nativeObjectWrapperList).iterator();
    }

    static final class IntegerStack {
        private int[] stack;
        private int top = 0;

        public IntegerStack(int initialCapacity) {
            this.stack = new int[initialCapacity];
        }

        void push(int i) {
            if (this.top >= this.stack.length) {
                this.stack = Arrays.copyOf(this.stack, this.stack.length * 2);
            }
            this.stack[this.top++] = i;
        }

        int pop() {
            if (this.top <= 0) {
                return -1;
            }
            return this.stack[--this.top];
        }

        void addToFreeList(int start, int end) {
            for (int i = end - 1; i >= start; --i) {
                this.push(i);
            }
        }
    }
}

