/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.INativePlugin;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.IdpAuthHelper;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.utils.RequestUtils;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftProperties;
import com.amazon.redshift.util.RedshiftState;
import java.util.Map;

public final class NativeAuthPluginHelper
extends IdpAuthHelper {
    private NativeAuthPluginHelper() {
    }

    public static RedshiftProperties setNativeAuthPluginProperties(RedshiftProperties info, RedshiftJDBCSettings settings, RedshiftLogger log) throws RedshiftException {
        try {
            String authProfile = RedshiftConnectionImpl.getOptionalConnSetting(RedshiftProperty.AUTH_PROFILE.getName(), info);
            info = NativeAuthPluginHelper.setAuthProperties(info, settings, log);
            String idpToken = NativeAuthPluginHelper.getNativeAuthPluginCredentials(settings, log, authProfile);
            if (RedshiftLogger.isEnable()) {
                log.logInfo("NativeAuthPluginHelper: Obtained idp token of length={0}", idpToken != null ? idpToken.length() : -1);
            }
            info.put(RedshiftProperty.WEB_IDENTITY_TOKEN.getName(), idpToken);
            return info;
        }
        catch (RedshiftException re) {
            if (RedshiftLogger.isEnable()) {
                log.logError(re);
            }
            throw re;
        }
    }

    private static String getNativeAuthPluginCredentials(RedshiftJDBCSettings settings, RedshiftLogger log, String authProfile) throws RedshiftException {
        Object plugin;
        INativePlugin provider;
        String idpToken;
        block17: {
            idpToken = null;
            provider = null;
            if (!Utils.isNullOrEmpty(settings.m_credentialsProvider)) {
                try {
                    Class<INativePlugin> clazz = Class.forName(settings.m_credentialsProvider).asSubclass(INativePlugin.class);
                    provider = clazz.newInstance();
                    if (provider instanceof INativePlugin) {
                        plugin = provider;
                        plugin.setLogger(log);
                        for (Map.Entry<String, String> entry : settings.m_pluginArgs.entrySet()) {
                            String pluginArgKey = entry.getKey();
                            plugin.addParameter(pluginArgKey, entry.getValue());
                        }
                        break block17;
                    }
                    RedshiftException err = new RedshiftException(GT.tr("Invalid credentials provider class {0}", settings.m_credentialsProvider), RedshiftState.UNEXPECTED_ERROR);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    RedshiftException err = new RedshiftException(GT.tr("Invalid credentials provider class {0}", settings.m_credentialsProvider), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                catch (NumberFormatException e) {
                    RedshiftException err = new RedshiftException(GT.tr("{0} : {1}", e.getMessage(), settings.m_credentialsProvider), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
                catch (IllegalArgumentException e) {
                    RedshiftException err = new RedshiftException(GT.tr("Error initializing credentials provider: {0}", e.getMessage()), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
                    if (RedshiftLogger.isEnable()) {
                        log.log(LogLevel.ERROR, err.toString(), new Object[0]);
                    }
                    throw err;
                }
            }
            RedshiftException err = new RedshiftException(GT.tr("Required credentials provider class parameter is null or empty {0}", settings.m_credentialsProvider), RedshiftState.UNEXPECTED_ERROR);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.ERROR, err.toString(), new Object[0]);
            }
            throw err;
        }
        if (RedshiftLogger.isEnable()) {
            log.log(LogLevel.DEBUG, "IDP Credential Provider {0}:{1}", provider, settings.m_credentialsProvider);
        }
        if (RedshiftLogger.isEnable()) {
            log.log(LogLevel.DEBUG, "Calling provider.getCredentials()", new Object[0]);
        }
        settings.m_idpToken = idpToken;
        NativeTokenHolder credentials = provider.getCredentials();
        if (credentials == null || RequestUtils.isCredentialExpired(credentials.getExpiration())) {
            plugin = (IPlugin)((Object)provider);
            if (RedshiftLogger.isEnable()) {
                log.log(LogLevel.DEBUG, "Calling plugin.getIdpToken()", new Object[0]);
            }
            settings.m_idpToken = idpToken = plugin.getIdpToken();
        } else {
            idpToken = credentials.getAccessToken();
        }
        return idpToken;
    }
}

