/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.question_answering.sentence;

import lombok.Generated;

public class Sentence {
    private final String text;
    private final int startIndex;
    private final int endIndex;
    private final int position;
    private final SentenceType type;

    public Sentence(String text, int startIndex, int endIndex, int position, SentenceType type) {
        if (text == null) {
            throw new IllegalArgumentException("Sentence text cannot be null");
        }
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException("Invalid sentence indices");
        }
        if (position < 0) {
            throw new IllegalArgumentException("Invalid sentence position");
        }
        this.text = text;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.position = position;
        this.type = type != null ? type : SentenceType.STATEMENT;
    }

    public int length() {
        return this.text.length();
    }

    public boolean isEmpty() {
        return this.text.trim().isEmpty();
    }

    @Generated
    public static SentenceBuilder builder() {
        return new SentenceBuilder();
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public int getStartIndex() {
        return this.startIndex;
    }

    @Generated
    public int getEndIndex() {
        return this.endIndex;
    }

    @Generated
    public int getPosition() {
        return this.position;
    }

    @Generated
    public SentenceType getType() {
        return this.type;
    }

    @Generated
    public String toString() {
        return "Sentence(text=" + this.getText() + ", startIndex=" + this.getStartIndex() + ", endIndex=" + this.getEndIndex() + ", position=" + this.getPosition() + ", type=" + String.valueOf((Object)this.getType()) + ")";
    }

    public static enum SentenceType {
        STATEMENT,
        QUESTION,
        EXCLAMATION,
        INCOMPLETE;

    }

    @Generated
    public static class SentenceBuilder {
        @Generated
        private String text;
        @Generated
        private int startIndex;
        @Generated
        private int endIndex;
        @Generated
        private int position;
        @Generated
        private SentenceType type;

        @Generated
        SentenceBuilder() {
        }

        @Generated
        public SentenceBuilder text(String text) {
            this.text = text;
            return this;
        }

        @Generated
        public SentenceBuilder startIndex(int startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        @Generated
        public SentenceBuilder endIndex(int endIndex) {
            this.endIndex = endIndex;
            return this;
        }

        @Generated
        public SentenceBuilder position(int position) {
            this.position = position;
            return this;
        }

        @Generated
        public SentenceBuilder type(SentenceType type) {
            this.type = type;
            return this;
        }

        @Generated
        public Sentence build() {
            return new Sentence(this.text, this.startIndex, this.endIndex, this.position, this.type);
        }

        @Generated
        public String toString() {
            return "Sentence.SentenceBuilder(text=" + this.text + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", position=" + this.position + ", type=" + String.valueOf((Object)this.type) + ")";
        }
    }
}

