/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.statestore;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.execution.statement.StatementModel;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.OpenSearchStateStoreUtil;
import org.opensearch.sql.spark.execution.statestore.StateStore;
import org.opensearch.sql.spark.execution.statestore.StatementStorageService;
import org.opensearch.sql.spark.execution.xcontent.StatementModelXContentSerializer;

public class OpenSearchStatementStorageService
implements StatementStorageService {
    private static final Logger LOG = LogManager.getLogger();
    private final StateStore stateStore;
    private final StatementModelXContentSerializer serializer;

    @Override
    public StatementModel createStatement(StatementModel statementModel, AsyncQueryRequestContext asyncQueryRequestContext) {
        try {
            return this.stateStore.create(statementModel.getId(), statementModel, StatementModel::copy, OpenSearchStateStoreUtil.getIndexName(statementModel.getDatasourceName()));
        }
        catch (VersionConflictEngineException e) {
            String errorMsg = "statement already exist. " + String.valueOf(statementModel.getStatementId());
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    @Override
    public Optional<StatementModel> getStatement(String id, String datasourceName, AsyncQueryRequestContext asyncQueryRequestContext) {
        return this.stateStore.get(id, this.serializer::fromXContent, OpenSearchStateStoreUtil.getIndexName(datasourceName));
    }

    @Override
    public StatementModel updateStatementState(StatementModel oldStatementModel, StatementState statementState, AsyncQueryRequestContext asyncQueryRequestContext) {
        try {
            return this.stateStore.updateState(oldStatementModel, statementState, StatementModel::copyWithState, OpenSearchStateStoreUtil.getIndexName(oldStatementModel.getDatasourceName()));
        }
        catch (DocumentMissingException e) {
            String errorMsg = String.format("cancel statement failed. no statement found. statement: %s.", oldStatementModel.getStatementId());
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        catch (VersionConflictEngineException e) {
            StatementModel statementModel = this.getStatement(oldStatementModel.getId(), oldStatementModel.getDatasourceName(), asyncQueryRequestContext).orElse(oldStatementModel);
            String errorMsg = String.format("cancel statement failed. current statementState: %s statement: %s.", new Object[]{statementModel.getStatementState(), statementModel.getStatementId()});
            LOG.error(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    @Generated
    public OpenSearchStatementStorageService(StateStore stateStore, StatementModelXContentSerializer serializer) {
        this.stateStore = stateStore;
        this.serializer = serializer;
    }
}

