/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import org.opensearch.protobufs.FieldSort;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.grpc.proto.request.search.sort.NestedSortProtoUtils;
import org.opensearch.transport.grpc.proto.response.common.FieldValueProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.util.ProtobufEnumUtils;

public class FieldSortBuilderProtoUtils {
    private FieldSortBuilderProtoUtils() {
    }

    public static FieldSortBuilder fromProto(String fieldName, FieldSort fieldSort, QueryBuilderProtoConverterRegistry registry) {
        if (fieldName == null || fieldName.isEmpty() || fieldName.equals("_score")) {
            throw new IllegalArgumentException("Field name is required and cannot be '_score'. Use ScoreSort for score-based sorting.");
        }
        if (fieldSort == null) {
            throw new IllegalArgumentException("FieldSort cannot be null");
        }
        FieldSortBuilder builder = new FieldSortBuilder(fieldName);
        if (fieldSort.hasOrder()) {
            builder.order(SortOrder.fromString((String)ProtobufEnumUtils.convertToString(fieldSort.getOrder())));
        }
        if (fieldSort.hasMissing()) {
            Object missing = FieldValueProtoUtils.fromProto(fieldSort.getMissing(), false);
            builder.missing(missing);
        }
        if (fieldSort.hasMode()) {
            builder.sortMode(SortMode.fromString((String)ProtobufEnumUtils.convertToString(fieldSort.getMode())));
        }
        if (fieldSort.hasNumericType()) {
            builder.setNumericType(ProtobufEnumUtils.convertToString(fieldSort.getNumericType()));
        }
        if (fieldSort.hasUnmappedType()) {
            builder.unmappedType(ProtobufEnumUtils.convertToString(fieldSort.getUnmappedType()));
        }
        if (fieldSort.hasNested()) {
            builder.setNestedSort(NestedSortProtoUtils.fromProto(fieldSort.getNested(), registry));
        }
        return builder;
    }
}

