/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2025 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MIGRAPHX_GUARD_AMDMIGRAPHX_OP_BUILDER_INSERT_HPP
#define MIGRAPHX_GUARD_AMDMIGRAPHX_OP_BUILDER_INSERT_HPP

#include <string>
#include <vector>
#include <migraphx/instruction_ref.hpp>
#include <migraphx/module.hpp>
#include <migraphx/make_op.hpp>

namespace migraphx {
inline namespace MIGRAPHX_INLINE_NS {
namespace op {
namespace builder {

MIGRAPHX_EXPORT std::vector<instruction_ref> insert(const std::string& name,
                                                    module& m,
                                                    instruction_ref ins,
                                                    const std::vector<instruction_ref>& args,
                                                    const value& options);

MIGRAPHX_EXPORT std::vector<instruction_ref> insert(const std::string& name,
                                                    module& m,
                                                    instruction_ref ins,
                                                    const std::vector<instruction_ref>& args,
                                                    const std::vector<module_ref>& module_args,
                                                    const value& options);

MIGRAPHX_EXPORT std::vector<instruction_ref> add(const std::string& name,
                                                 module& m,
                                                 const std::vector<instruction_ref>& args,
                                                 const value& options);

MIGRAPHX_EXPORT std::vector<instruction_ref> add(const std::string& name,
                                                 module& m,
                                                 const std::vector<instruction_ref>& args,
                                                 const std::vector<module_ref>& module_args,
                                                 const value& options);
template <class... Ins>
instruction_ref
insert_common_op(module& m, instruction_ref ins, const std::string& op_name, Ins... args)
{
    return insert_common_op(m, ins, make_op(op_name), {args...});
}

} // namespace builder
} // namespace op
} // namespace MIGRAPHX_INLINE_NS
} // namespace migraphx

#endif
