/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class NormalizeDistanceNode extends ImplicitNode {

	public NormalizeDistanceNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the input for the function id
	 *
	 * @return the input port for the function
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputFunctionID() throws Lib3MFException {
		Pointer bufferFunction = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getinputfunctionid.invokeInt(new java.lang.Object[]{mHandle, bufferFunction}));
		Pointer valueFunction = bufferFunction.getPointer(0);
		ImplicitPort function = null;
		if (valueFunction == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Function was a null pointer");
		}
		function = mWrapper.PolymorphicFactory(valueFunction, ImplicitPort.class);
		return function;
	}

	/**
	 * Retrieves the input for the position
	 *
	 * @return the input port for the position (vector)
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputPos() throws Lib3MFException {
		Pointer bufferPos = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getinputpos.invokeInt(new java.lang.Object[]{mHandle, bufferPos}));
		Pointer valuePos = bufferPos.getPointer(0);
		ImplicitPort pos = null;
		if (valuePos == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Pos was a null pointer");
		}
		pos = mWrapper.PolymorphicFactory(valuePos, ImplicitPort.class);
		return pos;
	}

	/**
	 * Retrieves the input for the finite difference step
	 *
	 * @return the input port for the finite difference step
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputStep() throws Lib3MFException {
		Pointer bufferStep = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getinputstep.invokeInt(new java.lang.Object[]{mHandle, bufferStep}));
		Pointer valueStep = bufferStep.getPointer(0);
		ImplicitPort step = null;
		if (valueStep == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Step was a null pointer");
		}
		step = mWrapper.PolymorphicFactory(valueStep, ImplicitPort.class);
		return step;
	}

	/**
	 * Sets the name of the referenced scalar output
	 *
	 * @param scalarOutputName the name of the scalar output of the referenced function
	 * @throws Lib3MFException
	 */
	public void setScalarOutputName(String scalarOutputName) throws Lib3MFException {
		byte[] bytesScalarOutputName = scalarOutputName.getBytes(StandardCharsets.UTF_8);
		Memory bufferScalarOutputName = new Memory(bytesScalarOutputName.length + 1);
		bufferScalarOutputName.write(0, bytesScalarOutputName, 0, bytesScalarOutputName.length);
		bufferScalarOutputName.setByte(bytesScalarOutputName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_setscalaroutputname.invokeInt(new java.lang.Object[]{mHandle, bufferScalarOutputName}));
	}

	/**
	 * Retrieves the name of the referenced scalar output
	 *
	 * @return the name of the scalar output of the referenced function
	 * @throws Lib3MFException
	 */
	public String getScalarOutputName() throws Lib3MFException {
		Pointer bytesNeededScalarOutputName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getscalaroutputname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededScalarOutputName, null}));
		int sizeScalarOutputName = bytesNeededScalarOutputName.getInt(0);
		Pointer bufferScalarOutputName = new Memory(sizeScalarOutputName);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getscalaroutputname.invokeInt(new java.lang.Object[]{mHandle, sizeScalarOutputName, bytesNeededScalarOutputName, bufferScalarOutputName}));
		return new String(bufferScalarOutputName.getByteArray(0, sizeScalarOutputName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the name of the referenced vector input
	 *
	 * @param vectorInputName the name of the vector input (float3) of the referenced function
	 * @throws Lib3MFException
	 */
	public void setVectorInputName(String vectorInputName) throws Lib3MFException {
		byte[] bytesVectorInputName = vectorInputName.getBytes(StandardCharsets.UTF_8);
		Memory bufferVectorInputName = new Memory(bytesVectorInputName.length + 1);
		bufferVectorInputName.write(0, bytesVectorInputName, 0, bytesVectorInputName.length);
		bufferVectorInputName.setByte(bytesVectorInputName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_setvectorinputname.invokeInt(new java.lang.Object[]{mHandle, bufferVectorInputName}));
	}

	/**
	 * Retrieves the name of the referenced vector input
	 *
	 * @return the name of the vector input (float3) of the referenced function
	 * @throws Lib3MFException
	 */
	public String getVectorInputName() throws Lib3MFException {
		Pointer bytesNeededVectorInputName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getvectorinputname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededVectorInputName, null}));
		int sizeVectorInputName = bytesNeededVectorInputName.getInt(0);
		Pointer bufferVectorInputName = new Memory(sizeVectorInputName);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getvectorinputname.invokeInt(new java.lang.Object[]{mHandle, sizeVectorInputName, bytesNeededVectorInputName, bufferVectorInputName}));
		return new String(bufferVectorInputName.getByteArray(0, sizeVectorInputName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Retrieves the normalized result output
	 *
	 * @return the output port for the normalized distance
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputResult() throws Lib3MFException {
		Pointer bufferResult = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_normalizedistancenode_getoutputresult.invokeInt(new java.lang.Object[]{mHandle, bufferResult}));
		Pointer valueResult = bufferResult.getPointer(0);
		ImplicitPort result = null;
		if (valueResult == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Result was a null pointer");
		}
		result = mWrapper.PolymorphicFactory(valueResult, ImplicitPort.class);
		return result;
	}


}

