/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.permission;

import java.util.HashMap;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.permission.ResourcePolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;

public class ResourcePolicyProviderFactory
implements PolicyProviderFactory<ResourcePermissionRepresentation> {
    private ResourcePolicyProvider provider = new ResourcePolicyProvider();

    public String getName() {
        return "Resource-Based";
    }

    public String getGroup() {
        return "Permission";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public Class<ResourcePermissionRepresentation> getRepresentationType() {
        return ResourcePermissionRepresentation.class;
    }

    public ResourcePermissionRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
        representation.setResourceType((String)policy.getConfig().get("defaultResourceType"));
        return representation;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public void onCreate(Policy policy, ResourcePermissionRepresentation representation, AuthorizationProvider authorization) {
        this.updateResourceType(policy, representation);
    }

    public void onUpdate(Policy policy, ResourcePermissionRepresentation representation, AuthorizationProvider authorization) {
        this.updateResourceType(policy, representation);
    }

    private void updateResourceType(Policy policy, ResourcePermissionRepresentation representation) {
        if (representation != null) {
            HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
            config.compute("defaultResourceType", (key, value) -> {
                String resourceType = representation.getResourceType();
                return resourceType != null ? representation.getResourceType() : null;
            });
            policy.setConfig(config);
        }
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "resource";
    }
}

