/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class EntityAssembler<T>
implements DomainResultAssembler<T> {
    private final JavaType<T> javaType;
    private final EntityInitializer<InitializerData> initializer;

    public EntityAssembler(JavaType<T> javaType, EntityInitializer<?> initializer) {
        this.javaType = javaType;
        this.initializer = initializer;
    }

    @Override
    public JavaType<T> getAssembledJavaType() {
        return this.javaType;
    }

    @Override
    public T assemble(RowProcessingState rowProcessingState) {
        Object data = this.initializer.getData(rowProcessingState);
        Initializer.State state = ((InitializerData)data).getState();
        if (state == Initializer.State.KEY_RESOLVED) {
            this.initializer.resolveInstance((InitializerData)data);
        }
        return (T)this.initializer.getResolvedInstance((InitializerData)data);
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        this.initializer.resolveState(rowProcessingState);
    }

    @Override
    public EntityInitializer<?> getInitializer() {
        return this.initializer;
    }

    @Override
    public <X> void forEachResultAssembler(BiConsumer<Initializer<?>, X> consumer, X arg) {
        if (this.initializer.isResultInitializer()) {
            consumer.accept(this.initializer, arg);
        }
    }
}

