/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.providers.serialisers;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class StreamingOutputMessageBodyWriter
implements ServerMessageBodyWriter<StreamingOutput> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return StreamingOutputMessageBodyWriter.doIsWriteable(type);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return StreamingOutputMessageBodyWriter.doIsWriteable(type);
    }

    private static boolean doIsWriteable(Class<?> type) {
        return StreamingOutput.class.isAssignableFrom(type);
    }

    public long getSize(StreamingOutput streamingOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(StreamingOutput streamingOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        streamingOutput.write(entityStream);
    }

    @Override
    public void writeResponse(StreamingOutput o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        o.write(context.getOrCreateOutputStream());
    }
}

