/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Function;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.RegexException;
import edu.washington.cs.knowitall.regex.RegularExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegularExpressionParser<E>
implements Function<String, RegularExpression<E>> {
    public abstract Expression.BaseExpression<E> factory(String var1);

    public RegularExpression<E> parse(String string) {
        List<Expression<E>> expressions = this.tokenize(string);
        return new RegularExpression<E>(expressions);
    }

    public RegularExpression<E> apply(String string) {
        return this.parse(string);
    }

    public String readToken(String remaining) {
        int end;
        int start = 0;
        char c = remaining.charAt(0);
        if (c == '<') {
            end = RegularExpressionParser.indexOfClose(remaining, start, '<', '>');
        } else if (c == '[') {
            end = RegularExpressionParser.indexOfClose(remaining, start, '[', ']');
        } else {
            throw new IllegalStateException();
        }
        if (end == -1) {
            throw new RegexException.TokenizationRegexException("bad token. Non-matching brackets (<> or []): " + start + ":\"" + remaining.substring(start) + "\"");
        }
        String token = remaining.substring(start, end + 1);
        return token;
    }

    public List<Expression<E>> tokenize(String string) {
        ArrayList<Expression<Expression<E>>> expressions = new ArrayList<Expression<Expression<E>>>();
        Pattern whitespacePattern = Pattern.compile("\\s+");
        Pattern unaryPattern = Pattern.compile("[*?+]");
        Pattern minMaxPattern = Pattern.compile("\\{(\\d+),(\\d+)\\}");
        Pattern binaryPattern = Pattern.compile("[|]");
        ArrayList<String> tokens = new ArrayList<String>();
        int stack = 32;
        int start = 0;
        while (start < string.length()) {
            Expression<E> base;
            Matcher matcher = whitespacePattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                start = matcher.end();
                continue;
            }
            char c = string.charAt(start);
            if (c == '(' || c == '<' || c == '[' || c == '$' || c == '^') {
                if (string.charAt(start) == '(') {
                    int end = RegularExpressionParser.indexOfClose(string, start, '(', ')');
                    if (end == -1) {
                        throw new RegexException.TokenizationRegexException("unclosed parenthesis: " + start + ":\"" + string.substring(start) + ")\"");
                    }
                    String group = string.substring(start + 1, end);
                    start = end + 1;
                    Pattern namedPattern = Pattern.compile("<(\\w*)>:(.*)");
                    Pattern unnamedPattern = Pattern.compile("\\?:(.*)");
                    matcher = namedPattern.matcher(group);
                    if (matcher.matches()) {
                        String groupName = matcher.group(1);
                        group = matcher.group(2);
                        List<Expression<E>> groupExpressions = this.tokenize(group);
                        expressions.add(new Expression.NamedGroup<E>(groupName, groupExpressions));
                    } else {
                        List<Expression<E>> groupExpressions;
                        matcher = unnamedPattern.matcher(group);
                        if (matcher.matches()) {
                            group = matcher.group(1);
                            groupExpressions = this.tokenize(group);
                            expressions.add(new Expression.NonMatchingGroup<E>(groupExpressions));
                        } else {
                            groupExpressions = this.tokenize(group);
                            expressions.add(new Expression.MatchingGroup<E>(groupExpressions));
                        }
                    }
                } else if (c == '<' || c == '[') {
                    String token = this.readToken(string.substring(start));
                    try {
                        String tokenInside = token.substring(1, token.length() - 1);
                        base = this.factory(tokenInside);
                        expressions.add(base);
                        start += token.length();
                    }
                    catch (Exception e) {
                        throw new RegexException.TokenizationRegexException("error parsing token: " + token, e);
                    }
                } else if (c == '^') {
                    expressions.add(new Expression.StartAssertion());
                    ++start;
                } else if (c == '$') {
                    expressions.add(new Expression.EndAssertion());
                    ++start;
                }
                if (stack != 124) continue;
                try {
                    stack = 32;
                    if (expressions.size() < 2) {
                        throw new IllegalStateException("OR operator is applied to fewer than 2 elements.");
                    }
                    Expression expr1 = (Expression)expressions.remove(expressions.size() - 1);
                    Expression expr2 = (Expression)expressions.remove(expressions.size() - 1);
                    expressions.add(new Expression.Or(expr1, expr2));
                    continue;
                }
                catch (Exception e) {
                    throw new RegexException.TokenizationRegexException("error parsing OR (|) operator.", e);
                }
            }
            matcher = unaryPattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                Expression expr;
                char operator = matcher.group(0).charAt(0);
                Expression base2 = (Expression)expressions.remove(expressions.size() - 1);
                if (operator == '?') {
                    expr = new Expression.Option(base2);
                } else if (operator == '*') {
                    expr = new Expression.Star(base2);
                } else if (operator == '+') {
                    expr = new Expression.Plus(base2);
                } else {
                    throw new IllegalStateException();
                }
                expressions.add(expr);
                start = matcher.end();
                continue;
            }
            matcher = minMaxPattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                int minOccurrences = Integer.parseInt(matcher.group(1));
                int maxOccurrences = Integer.parseInt(matcher.group(2));
                base = (Expression)expressions.remove(expressions.size() - 1);
                Expression.MinMax<E> expr = new Expression.MinMax<E>(base, minOccurrences, maxOccurrences);
                expressions.add(expr);
                start = matcher.end();
                continue;
            }
            matcher = binaryPattern.matcher(string);
            if (matcher.region(start, string.length()).lookingAt()) {
                tokens.add(matcher.group(0));
                stack = 124;
                start = matcher.end();
                continue;
            }
            throw new RegexException.TokenizationRegexException("unknown symbol: " + string.substring(start));
        }
        if (stack == 124) {
            throw new RegexException.TokenizationRegexException("OR remains on the stack.");
        }
        return expressions;
    }

    private static int indexOfClose(String string, int start, char open, char close) {
        --start;
        int count = 0;
        do {
            if (++start >= string.length()) {
                return -1;
            }
            char c = string.charAt(start);
            if (c == open) {
                ++count;
                continue;
            }
            if (c != close) continue;
            --count;
        } while (count > 0);
        return start;
    }
}

