/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParameterListOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyUncheckedAssignmentOfMemberOfRawTypeInspection
extends BaseInspection {
    @Override
    protected String buildErrorString(Object ... args) {
        PsiType expectedType = (PsiType)args[0];
        PsiType rType = (PsiType)args[1];
        return GroovyBundle.message("cannot.assign", rType.getPresentableText(), expectedType.getPresentableText());
    }

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
            PsiMethod method;
            GrParameterListOwner owner;
            PsiType type;
            GrExpression value;
            if (returnStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((value = returnStatement.getReturnValue()) != null && (type = value.getType()) != null && (owner = (GrParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GrParameterListOwner.class)) instanceof PsiMethod && !(method = (PsiMethod)owner).isConstructor()) {
                PsiType methodType = method.getReturnType();
                PsiType returnType = value.getType();
                if (methodType != null && !PsiTypes.voidType().equals((Object)methodType) && returnType != null) {
                    this.checkAssignability(methodType, value, value);
                }
            }
        }

        @Override
        public void visitNamedArgument(@NotNull GrNamedArgument argument) {
            PsiType expectedType;
            GrArgumentLabel label;
            if (argument == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((label = argument.getLabel()) != null && (expectedType = label.getExpectedArgumentType()) != null) {
                PsiType argType;
                expectedType = TypeConversionUtil.erasure((PsiType)expectedType);
                GrExpression expr = argument.getExpression();
                if (expr != null && (argType = expr.getType()) != null) {
                    PsiClassType listType = JavaPsiFacade.getInstance((Project)argument.getProject()).getElementFactory().createTypeByFQClassName("java.util.List", argument.getResolveScope());
                    if (listType.isAssignableFrom(argType)) {
                        return;
                    }
                    this.checkAssignability(expectedType, expr, argument);
                }
            }
        }

        @Override
        public void visitVariable(@NotNull GrVariable variable) {
            PsiType rType;
            if (variable == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            PsiType varType = variable.getType();
            GrExpression initializer = variable.getInitializerGroovy();
            if (initializer != null && (rType = initializer.getType()) != null) {
                this.checkAssignability(varType, initializer, initializer);
            }
        }

        @Override
        public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
            if (assignment == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            super.visitAssignmentExpression(assignment);
            if (assignment.isOperatorAssignment()) {
                return;
            }
            GrExpression lValue = assignment.getLValue();
            if (!PsiUtil.mightBeLValue(lValue)) {
                return;
            }
            GrExpression rValue = assignment.getRValue();
            if (rValue == null) {
                return;
            }
            PsiType lType = lValue.getNominalType();
            PsiType rType = rValue.getType();
            if (PsiImplUtil.isSpreadAssignment(lValue) && lType instanceof PsiClassType) {
                PsiType[] types;
                PsiClassType pct = (PsiClassType)lType;
                PsiClass clazz = pct.resolve();
                if (clazz != null && "java.util.List".equals(clazz.getQualifiedName()) && (types = pct.getParameters()).length == 1 && types[0] != null && rType != null) {
                    this.checkAssignability(types[0], rValue, assignment);
                }
                return;
            }
            if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
                return;
            }
            if (lType != null && rType != null) {
                this.checkAssignability(lType, rValue, rValue);
            }
        }

        private void checkAssignability(PsiType lType, GrExpression rExpr, GroovyPsiElement element) {
            PsiType rType;
            if (PsiUtil.isRawClassMemberAccess(rExpr) && !TypesUtil.isAssignable(lType, rType = rExpr.getType(), element)) {
                this.registerError((PsiElement)element, lType, rType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/assignment/GroovyUncheckedAssignmentOfMemberOfRawTypeInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReturnStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNamedArgument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

