/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.intcaches.SLRUIntObjectCache;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.LockedCacheWrapper;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import com.intellij.util.indexing.impl.SlruIndexStorageCacheProvider;
import com.intellij.util.io.InlineKeyDescriptor;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\t\u001a\u00020\nH\u0016Jn\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\r\"\b\b\u0000\u0010\u000e*\u00020\u0010\"\u0004\b\u0001\u0010\u000f2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u00130\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u00130\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "<init>", "()V", "THREAD_SAFE_IMPL", "", "totalReads", "Ljava/util/concurrent/atomic/AtomicLong;", "totalUncachedReads", "totalEvicted", "", "totalReadsUncached", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSizeHint", "", "SlruCache", "SlruCacheForIntKeys", "intellij.platform.util"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMapIndexStorageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,367:1\n23#2:368\n*S KotlinDebug\n*F\n+ 1 MapIndexStorageCache.kt\ncom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider\n*L\n102#1:368\n*E\n"})
public final class SlruIndexStorageCacheProvider
implements MapIndexStorageCacheProvider {
    @NotNull
    public static final SlruIndexStorageCacheProvider INSTANCE = new SlruIndexStorageCacheProvider();
    private static final boolean THREAD_SAFE_IMPL = true;
    @NotNull
    private static final AtomicLong totalReads;
    @NotNull
    private static final AtomicLong totalUncachedReads;
    @NotNull
    private static final AtomicLong totalEvicted;

    private SlruIndexStorageCacheProvider() {
    }

    @Override
    public long totalReads() {
        return totalReads.get();
    }

    @Override
    public long totalReadsUncached() {
        return totalUncachedReads.get();
    }

    @Override
    public long totalEvicted() {
        return totalEvicted.get();
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSizeHint) {
        Intrinsics.checkNotNullParameter(valueReader, "valueReader");
        Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
        Intrinsics.checkNotNullParameter(hashingStrategy, "hashingStrategy");
        MapIndexStorageCache underlyingCache = hashingStrategy instanceof InlineKeyDescriptor ? (MapIndexStorageCache)new SlruCacheForIntKeys<Key, Value>(valueReader, evictedValuesPersister, (InlineKeyDescriptor)hashingStrategy, cacheSizeHint) : (MapIndexStorageCache)new SlruCache<Key, Value>(valueReader, evictedValuesPersister, hashingStrategy, cacheSizeHint);
        return new LockedCacheWrapper(underlyingCache);
    }

    static {
        SlruIndexStorageCacheProvider $this$thisLogger$iv = INSTANCE;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SlruIndexStorageCacheProvider.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        logger.info("SLRU cache will be used for indexes");
        totalReads = new AtomicLong();
        totalUncachedReads = new AtomicLong();
        totalEvicted = new AtomicLong();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000*\u0001\u0015\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BQ\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider$SlruCache;", "Key", "", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "<init>", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;Lcom/intellij/util/containers/hash/EqualityPolicy;I)V", "getValueReader", "()Ljava/util/function/Function;", "getEvictedValuesPersister", "()Ljava/util/function/BiConsumer;", "cache", "com/intellij/util/indexing/impl/SlruIndexStorageCacheProvider$SlruCache$cache$1", "Lcom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider$SlruCache$cache$1;", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "getCachedValues", "", "invalidateAll", "", "intellij.platform.util"})
    private static final class SlruCache<Key, Value>
    implements MapIndexStorageCache<Key, Value> {
        @NotNull
        private final Function<Key, ChangeTrackingValueContainer<Value>> valueReader;
        @NotNull
        private final BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister;
        @NotNull
        private final cache.1 cache;

        public SlruCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull EqualityPolicy<Key> hashingStrategy, int cacheSize) {
            Intrinsics.checkNotNullParameter(valueReader, "valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
            Intrinsics.checkNotNullParameter(hashingStrategy, "hashingStrategy");
            this.valueReader = valueReader;
            this.evictedValuesPersister = evictedValuesPersister;
            int n = cacheSize / 4;
            this.cache = new SLRUCache<Key, ChangeTrackingValueContainer<Value>>(cacheSize, hashingStrategy, this, n){
                final /* synthetic */ SlruCache<Key, Value> this$0;
                {
                    this.this$0 = $receiver;
                    super($cacheSize, $super_call_param$1, $hashingStrategy);
                }

                public ChangeTrackingValueContainer<Value> createValue(Key key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    SlruIndexStorageCacheProvider.access$getTotalUncachedReads$p().incrementAndGet();
                    ChangeTrackingValueContainer<Value> changeTrackingValueContainer = this.this$0.getValueReader().apply(key);
                    Intrinsics.checkNotNullExpressionValue(changeTrackingValueContainer, "apply(...)");
                    return changeTrackingValueContainer;
                }

                protected void onDropFromCache(Key key, ChangeTrackingValueContainer<Value> valueContainer) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Intrinsics.checkNotNullParameter(valueContainer, "valueContainer");
                    SlruIndexStorageCacheProvider.access$getTotalEvicted$p().incrementAndGet();
                    this.this$0.getEvictedValuesPersister().accept(key, valueContainer);
                }
            };
        }

        @NotNull
        public final Function<Key, ChangeTrackingValueContainer<Value>> getValueReader() {
            return this.valueReader;
        }

        @NotNull
        public final BiConsumer<Key, ChangeTrackingValueContainer<Value>> getEvictedValuesPersister() {
            return this.evictedValuesPersister;
        }

        @Override
        @NotNull
        public ChangeTrackingValueContainer<Value> read(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            totalReads.incrementAndGet();
            Object v = this.cache.get(key);
            Intrinsics.checkNotNullExpressionValue(v, "get(...)");
            return (ChangeTrackingValueContainer)v;
        }

        @Override
        @Nullable
        public ChangeTrackingValueContainer<Value> readIfCached(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            totalReads.incrementAndGet();
            return (ChangeTrackingValueContainer)this.cache.getIfCached(key);
        }

        @Override
        @NotNull
        public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
            Set set = this.cache.values();
            Intrinsics.checkNotNullExpressionValue(set, "values(...)");
            return set;
        }

        @Override
        public void invalidateAll() {
            this.cache.clear();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004BQ\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001b\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/util/indexing/impl/SlruIndexStorageCacheProvider$SlruCacheForIntKeys;", "Key", "", "Value", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "valueReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictedValuesPersister", "Ljava/util/function/BiConsumer;", "converter", "Lcom/intellij/util/io/InlineKeyDescriptor;", "cacheSize", "", "<init>", "(Ljava/util/function/Function;Ljava/util/function/BiConsumer;Lcom/intellij/util/io/InlineKeyDescriptor;I)V", "getValueReader", "()Ljava/util/function/Function;", "getEvictedValuesPersister", "()Ljava/util/function/BiConsumer;", "getConverter", "()Lcom/intellij/util/io/InlineKeyDescriptor;", "cache", "Lcom/intellij/util/containers/intcaches/SLRUIntObjectCache;", "read", "key", "(Ljava/lang/Object;)Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "readIfCached", "getCachedValues", "", "invalidateAll", "", "intellij.platform.util"})
    private static final class SlruCacheForIntKeys<Key, Value>
    implements MapIndexStorageCache<Key, Value> {
        @NotNull
        private final Function<Key, ChangeTrackingValueContainer<Value>> valueReader;
        @NotNull
        private final BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister;
        @NotNull
        private final InlineKeyDescriptor<Key> converter;
        @NotNull
        private final SLRUIntObjectCache<ChangeTrackingValueContainer<Value>> cache;

        public SlruCacheForIntKeys(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> valueReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictedValuesPersister, @NotNull InlineKeyDescriptor<Key> converter, int cacheSize) {
            Intrinsics.checkNotNullParameter(valueReader, "valueReader");
            Intrinsics.checkNotNullParameter(evictedValuesPersister, "evictedValuesPersister");
            Intrinsics.checkNotNullParameter(converter, "converter");
            this.valueReader = valueReader;
            this.evictedValuesPersister = evictedValuesPersister;
            this.converter = converter;
            this.cache = new SLRUIntObjectCache<Object>(cacheSize, cacheSize / 4, arg_0 -> SlruCacheForIntKeys.cache$lambda$0(this, arg_0), (arg_0, arg_1) -> SlruCacheForIntKeys.cache$lambda$2((arg_0, arg_1) -> SlruCacheForIntKeys.cache$lambda$1(this, arg_0, arg_1), arg_0, arg_1));
        }

        @NotNull
        public final Function<Key, ChangeTrackingValueContainer<Value>> getValueReader() {
            return this.valueReader;
        }

        @NotNull
        public final BiConsumer<Key, ChangeTrackingValueContainer<Value>> getEvictedValuesPersister() {
            return this.evictedValuesPersister;
        }

        @NotNull
        public final InlineKeyDescriptor<Key> getConverter() {
            return this.converter;
        }

        @Override
        @NotNull
        public ChangeTrackingValueContainer<Value> read(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            totalReads.incrementAndGet();
            ChangeTrackingValueContainer<Value> changeTrackingValueContainer = this.cache.getOrCreate(this.converter.toInt(key));
            Intrinsics.checkNotNullExpressionValue(changeTrackingValueContainer, "getOrCreate(...)");
            return changeTrackingValueContainer;
        }

        @Override
        @Nullable
        public ChangeTrackingValueContainer<Value> readIfCached(@NotNull Key key) {
            Intrinsics.checkNotNullParameter(key, "key");
            totalReads.incrementAndGet();
            return this.cache.getIfCached(this.converter.toInt(key));
        }

        @Override
        @NotNull
        public Collection<ChangeTrackingValueContainer<Value>> getCachedValues() {
            Collection<ChangeTrackingValueContainer<Value>> collection = this.cache.values();
            Intrinsics.checkNotNullExpressionValue(collection, "values(...)");
            return collection;
        }

        @Override
        public void invalidateAll() {
            this.cache.evictAll();
        }

        private static final ChangeTrackingValueContainer cache$lambda$0(SlruCacheForIntKeys this$0, int key) {
            totalUncachedReads.incrementAndGet();
            return this$0.valueReader.apply(this$0.converter.fromInt(key));
        }

        private static final Unit cache$lambda$1(SlruCacheForIntKeys this$0, int key, ChangeTrackingValueContainer valueContainer) {
            Intrinsics.checkNotNullParameter(valueContainer, "valueContainer");
            totalEvicted.incrementAndGet();
            this$0.evictedValuesPersister.accept(this$0.converter.fromInt(key), valueContainer);
            return Unit.INSTANCE;
        }

        private static final void cache$lambda$2(Function2 $tmp0, int key, Object value) {
            $tmp0.invoke(key, value);
        }
    }
}

