/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertArrayParameterToVarargIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertArrayParameterToVarargIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertArrayParameterToVarargIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertArrayParameterToVarargIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,65:1\n261#2:66\n261#2:67\n*S KotlinDebug\n*F\n+ 1 ConvertArrayParameterToVarargIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertArrayParameterToVarargIntention\n*L\n19#1:66\n56#1:67\n*E\n"})
public final class ConvertArrayParameterToVarargIntention
extends SelfTargetingIntention<KtParameter> {
    public ConvertArrayParameterToVarargIntention() {
        super(KtParameter.class, KotlinBundle.messagePointer((String)"convert.to.vararg.parameter", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtParameter element, int caretOffset) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getChildOfType$iv = (PsiElement)element;
        boolean $i$f$getChildOfType = false;
        KtTypeReference ktTypeReference = (KtTypeReference)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtTypeReference.class);
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        if (element.isLambdaParameter()) {
            return false;
        }
        if (element.isVarArg()) {
            return false;
        }
        ValueParameterDescriptor valueParameterDescriptor = SearchHelpersKt.getDescriptor(element);
        if (valueParameterDescriptor == null || (valueParameterDescriptor = valueParameterDescriptor.getType()) == null) {
            return false;
        }
        ValueParameterDescriptor type2 = valueParameterDescriptor;
        if (KotlinBuiltIns.isPrimitiveArray((KotlinType)type2)) {
            this.setTextGetter(this.getDefaultTextGetter());
            bl = true;
        } else if (KotlinBuiltIns.isArray((KotlinType)type2)) {
            KtTypeProjection typeProjection;
            KtTypeReference typeArgument;
            Object object = typeReference.getTypeElement();
            KtTypeReference ktTypeReference2 = typeArgument = object != null && (object = object.getTypeArgumentsAsTypes()) != null ? (KtTypeReference)CollectionsKt.firstOrNull((List)object) : null;
            Object[] objectArray = ktTypeReference2 != null ? ktTypeReference2.getParent() : null;
            KtTypeProjection ktTypeProjection = typeProjection = objectArray instanceof KtTypeProjection ? (KtTypeProjection)objectArray : null;
            boolean bl2 = ktTypeProjection != null ? !ktTypeProjection.hasModifier(KtTokens.IN_KEYWORD) : false;
            if (bl2) {
                Supplier supplier;
                if (!typeProjection.hasModifier(KtTokens.OUT_KEYWORD) && !KotlinBuiltIns.isPrimitiveType((KotlinType)PlatformKt.getBuiltIns((KtElement)element).getArrayElementType((KotlinType)type2))) {
                    objectArray = new Object[]{this.getDefaultText()};
                    supplier = KotlinBundle.messagePointer((String)"0.may.break.code", (Object[])objectArray);
                } else {
                    supplier = this.getDefaultTextGetter();
                }
                this.setTextGetter(supplier);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public void applyTo(@NotNull KtParameter element, @Nullable Editor editor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$getChildOfType$iv = (PsiElement)element;
        boolean $i$f$getChildOfType = false;
        KtTypeReference ktTypeReference = (KtTypeReference)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtTypeReference.class);
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        ValueParameterDescriptor valueParameterDescriptor = SearchHelpersKt.getDescriptor(element);
        if (valueParameterDescriptor == null || (valueParameterDescriptor = valueParameterDescriptor.getType()) == null) {
            return;
        }
        ValueParameterDescriptor type2 = valueParameterDescriptor;
        Object object2 = KotlinBuiltIns.getPrimitiveArrayElementType((KotlinType)type2);
        if ((object2 == null || (object2 = object2.getTypeName()) == null || (object2 = object2.asString()) == null) && ((object = typeReference.getTypeElement()) != null && (object = object.getTypeArgumentsAsTypes()) != null && (object = (KtTypeReference)CollectionsKt.firstOrNull((List)object)) != null ? object.getText() : (object2 = null)) == null) {
            return;
        }
        Object newType = object2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        typeReference.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createType((String)newType));
        element.addModifier(KtTokens.VARARG_KEYWORD);
    }
}

