/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinInlayParameterHintsProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "<init>", "()V", "getDefaultBlackList", "", "", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "element", "Lcom/intellij/psi/PsiElement;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "getBlackListDependencyLanguage", "Lcom/intellij/lang/Language;", "getInlayPresentation", "inlayText", "getMethodInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "elem", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinInlayParameterHintsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInlayParameterHintsProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/hints/KotlinInlayParameterHintsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class KotlinInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    public Set<String> getDefaultBlackList() {
        Object[] objectArray = new String[]{"*listOf", "*setOf", "*arrayOf", "*ListOf", "*SetOf", "*ArrayOf", "*assert*(*)", "*mapOf", "*MapOf", "kotlin.require*(*)", "kotlin.check*(*)", "*contains*(value)", "*containsKey(key)", "kotlin.lazyOf(value)", "*SequenceBuilder.resume(value)", "*SequenceBuilder.yield(value)", "kotlin.Triple", "org.gradle.api.Project.hasProperty(propertyName)", "org.gradle.api.Project.findProperty(propertyName)", "org.gradle.api.Project.file(path)", "org.gradle.api.Project.uri(path)", "jvmArgs(arguments)", "org.gradle.kotlin.dsl.DependencyHandlerScope.*(notation)", "org.gradle.kotlin.dsl.*(dependencyNotation)", "org.gradle.kotlin.dsl.kotlin(module)", "org.gradle.kotlin.dsl.kotlin(module,version)", "org.gradle.kotlin.dsl.project(path,configuration)"};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        HintInfo.MethodInfo methodInfo;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!HintType.PARAMETER_HINT.isApplicable(element)) {
            return null;
        }
        KtValueArgumentList ktValueArgumentList = element instanceof KtValueArgumentList ? (KtValueArgumentList)element : null;
        if (ktValueArgumentList == null || (ktValueArgumentList = ktValueArgumentList.getParent()) == null) {
            return null;
        }
        KtValueArgumentList parent = ktValueArgumentList;
        KtCallElement ktCallElement = parent instanceof KtCallElement ? (KtCallElement)parent : null;
        if (ktCallElement != null) {
            KtCallElement it = ktCallElement;
            boolean bl = false;
            methodInfo = this.getMethodInfo(it);
        } else {
            methodInfo = null;
        }
        return (HintInfo)methodInfo;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return HintType.PARAMETER_HINT.isApplicable(element) ? HintType.PARAMETER_HINT.provideHints(element) : CollectionsKt.emptyList();
    }

    @NotNull
    public Language getBlackListDependencyLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaLanguage, (String)"INSTANCE");
        return (Language)javaLanguage;
    }

    @NotNull
    public String getInlayPresentation(@NotNull String inlayText) {
        Intrinsics.checkNotNullParameter((Object)inlayText, (String)"inlayText");
        return inlayText;
    }

    private final HintInfo.MethodInfo getMethodInfo(KtCallElement elem) {
        CallableDescriptor resolvedCallee;
        ResolvedCall resolvedCall;
        ResolvedCall resolvedCall2 = resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)elem, null, 1, null);
        Object object = resolvedCallee = resolvedCall2 != null ? resolvedCall2.getCandidateDescriptor() : null;
        if (resolvedCallee instanceof FunctionDescriptor) {
            Object object2;
            List list2 = ((FunctionDescriptor)resolvedCallee).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            List paramNames2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), KotlinInlayParameterHintsProvider::getMethodInfo$lambda$0), KotlinInlayParameterHintsProvider::getMethodInfo$lambda$1), (Function1)getMethodInfo.paramNames.3.INSTANCE));
            if (resolvedCallee instanceof ConstructorDescriptor) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)resolvedCallee).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)classifierDescriptorWithTypeParameters, (String)"getContainingDeclaration(...)");
                object2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptorWithTypeParameters)).asString();
            } else {
                object2 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCallee));
                if (object2 == null || (object2 = object2.asString()) == null) {
                    return null;
                }
            }
            Object fqName2 = object2;
            return new HintInfo.MethodInfo((String)fqName2, paramNames2);
        }
        return null;
    }

    private static final Name getMethodInfo$lambda$0(ValueParameterDescriptor it) {
        return it.getName();
    }

    private static final boolean getMethodInfo$lambda$1(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isSpecial();
    }
}

