/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import java.text.DateFormat;

public class YAFFS2Utils {
    public static String parseName(byte[] buffer, int offset, int length) {
        byte b;
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i = offset; i < end && (b = buffer[i]) != 0; ++i) {
            result.append((char)(b & 0xFF));
        }
        return result.toString();
    }

    public static long parseInteger(byte[] buffer, int offset, int length) {
        long result = 0L;
        int end = offset + length;
        int start = offset;
        int j = 0;
        for (int i = start; i < end; ++i) {
            result += ((long)buffer[i] & 0xFFL) << 8 * j;
            ++j;
        }
        return result;
    }

    public static long parseFileSize(byte[] buffer, int offset, int length) {
        long result = 0L;
        int end = offset + length;
        int start = offset;
        int j = 0;
        int k = 0;
        for (int i = start; i < end; ++i) {
            if (buffer[i] == -1) {
                ++k;
            }
            result += ((long)buffer[i] & 0xFFL) << 8 * j;
            ++j;
        }
        if (k < 4) {
            return result;
        }
        return 0L;
    }

    public static String parseDateTime(byte[] buffer, int offset, int length) {
        long result = 0L;
        int end = offset + length;
        int start = offset;
        int j = 0;
        for (int i = start; i < end; ++i) {
            result += ((long)buffer[i] & 0xFFL) << 8 * j;
            ++j;
        }
        return DateFormat.getDateTimeInstance().format(result * 1000L);
    }

    public static final boolean isYAFFS2Image(Program program) {
        byte[] bytes = new byte[11];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes[0] == 3 && bytes[10] == 0;
    }
}

