/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.stringable.deprecated;

import ghidra.feature.vt.api.stringable.deprecated.ParameterStringable;
import ghidra.feature.vt.api.util.Stringable;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MultipleParameterStringable
extends Stringable {
    public static final String SHORT_NAME = "MULTI_PARAM";
    private static final String CUSTOM_DELIMITER = "\n";
    private List<ParameterStringable> parameterStringables = new ArrayList<ParameterStringable>();

    public MultipleParameterStringable() {
        this((List<ParameterStringable>)null);
    }

    public MultipleParameterStringable(List<ParameterStringable> parameterStringables) {
        super(SHORT_NAME);
        this.parameterStringables = parameterStringables;
        if (parameterStringables == null) {
            this.parameterStringables = new ArrayList<ParameterStringable>();
        }
    }

    @Override
    protected String doConvertToString(Program program) {
        StringBuffer buffy = new StringBuffer();
        for (Stringable stringable : this.parameterStringables) {
            buffy.append(Stringable.getString(stringable, program)).append(CUSTOM_DELIMITER);
        }
        return buffy.toString();
    }

    @Override
    protected void doRestoreFromString(String string, Program program) {
        if (string == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(string, CUSTOM_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Stringable stringable = Stringable.getStringable(token, program);
            if (!(stringable instanceof ParameterStringable)) {
                throw new AssertException("Coding Error: how can we get a stringable that is not the right type?");
            }
            this.parameterStringables.add((ParameterStringable)stringable);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 * (this.parameterStringables == null ? 0 : this.parameterStringables.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleParameterStringable other = (MultipleParameterStringable)obj;
        return !(this.parameterStringables == null ? other.parameterStringables != null : !this.parameterStringables.equals(other.parameterStringables));
    }

    @Override
    public String getDisplayString() {
        StringBuffer buffy = new StringBuffer();
        for (Stringable stringable : this.parameterStringables) {
            buffy.append(stringable.getDisplayString()).append('\n');
        }
        return buffy.toString();
    }

    public List<Parameter> getParameterDefinitions(Function destFunction) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        int ordinal = 0;
        for (ParameterStringable stringable : this.parameterStringables) {
            list.add(stringable.getParameterDefinition(destFunction, ordinal++));
        }
        return list;
    }
}

