/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.signature;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import java.util.ArrayList;

public class SignatureResult {
    public int[] features;
    public ArrayList<Address> calllist;
    public boolean hasunimplemented;
    public boolean hasbaddata;

    public static SignatureResult decode(Decoder decoder, Function func, boolean keepcalllist) throws DecoderException {
        int subel;
        int attribId;
        ArrayList<Integer> res = null;
        ArrayList<Address> calllist = null;
        boolean hasunimpl = false;
        boolean hasbaddata = false;
        if (keepcalllist) {
            calllist = new ArrayList<Address>();
        }
        int start = decoder.openElement(ElementId.ELEM_SIGNATURES);
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_UNIMPL.id()) {
                hasunimpl = decoder.readBool();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_BADDATA.id()) continue;
            hasbaddata = decoder.readBool();
        }
        res = new ArrayList<Integer>();
        while ((subel = decoder.openElement()) != 0) {
            if (subel == ElementId.ELEM_SIG.id()) {
                int val = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_VAL);
                res.add(val);
            } else {
                Address addr = AddressXML.decodeFromAttributes((Decoder)decoder);
                if (keepcalllist) {
                    calllist.add(addr);
                }
            }
            decoder.closeElement(subel);
        }
        decoder.closeElement(start);
        SignatureResult sigres = new SignatureResult();
        sigres.calllist = calllist;
        sigres.hasunimplemented = hasunimpl;
        sigres.hasbaddata = hasbaddata;
        sigres.features = new int[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            sigres.features[i] = (Integer)res.get(i);
        }
        return sigres;
    }
}

