/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.ExecutableAction;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class DockingKeyBindingAction
extends AbstractAction {
    protected Tool tool;
    protected DockingActionIf dockingAction;
    protected KeyStroke keyStroke;

    public DockingKeyBindingAction(Tool tool, DockingActionIf action, KeyStroke keyStroke) {
        super(KeyBindingUtils.parseKeyStroke(keyStroke));
        this.tool = tool;
        this.dockingAction = action;
        this.keyStroke = keyStroke;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public abstract ExecutableAction getExecutableAction(Component var1);

    public boolean isSystemKeybindingPrecedence() {
        return false;
    }

    protected ActionContext getLocalContext(ComponentProvider localProvider) {
        if (localProvider == null) {
            return new DefaultActionContext();
        }
        ActionContext actionContext = localProvider.getActionContext(null);
        if (actionContext != null) {
            return actionContext;
        }
        return new DefaultActionContext(localProvider, null);
    }

    public List<DockingActionIf> getActions() {
        return List.of(this.dockingAction);
    }
}

