/*
 * Decompiled with CFR 0.152.
 */
package org.phidias.compile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.phidias.compile.BundleJavaFileObject;
import org.phidias.compile.Constants;
import org.phidias.compile.ResourceResolver;
import org.phidias.compile.TPhLog;

public class ClassLoaderJavaManager
extends ForwardingJavaFileManager<JavaFileManager>
implements Constants {
    private ClassLoader _classLoader;
    private JavaFileManager _javaFileManager;
    private TPhLog _log;
    private List<String> _options = new ArrayList<String>();
    private ResourceResolver _resourceResolver;
    private boolean _strict;

    public ClassLoaderJavaManager(ClassLoader classLoader, JavaFileManager javaFileManager) throws IOException {
        this(classLoader, javaFileManager, null, false);
    }

    public ClassLoaderJavaManager(ClassLoader classLoader, JavaFileManager javaFileManager, List<String> options) throws IOException {
        this(classLoader, javaFileManager, options, false);
    }

    public ClassLoaderJavaManager(ClassLoader classLoader, JavaFileManager javaFileManager, List<String> options, boolean strict) throws IOException {
        super(javaFileManager);
        this._javaFileManager = javaFileManager;
        this._log = new TPhLog();
        this.setOptions(options);
        this._strict = strict;
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        if (location != StandardLocation.CLASS_PATH) {
            return this._javaFileManager.getClassLoader(location);
        }
        return this.getClassLoader();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (location == StandardLocation.CLASS_PATH && file instanceof BundleJavaFileObject) {
            BundleJavaFileObject bundleJavaFileObject = (BundleJavaFileObject)file;
            this._log.log("Infering binary name from " + bundleJavaFileObject);
            return bundleJavaFileObject.inferBinaryName();
        }
        return this._javaFileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> javaFileObjects = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH) {
            this._log.log("List available sources for {location=" + location + ", packageName=" + packageName + ", kinds=" + kinds + ", recurse=" + recurse + "}");
        }
        String packagePath = packageName.replace('.', '/');
        if (packageName.startsWith("java.") || location == StandardLocation.CLASS_PATH) {
            // empty if block
        }
        if (packageName.startsWith("java.") || location != StandardLocation.CLASS_PATH || javaFileObjects.isEmpty() && this.hasPackageCapability(packageName)) {
            for (JavaFileObject javaFileObject : this._javaFileManager.list(location, packagePath, kinds, recurse)) {
                if (location == StandardLocation.CLASS_PATH) {
                    this._log.log("\t" + javaFileObject);
                }
                javaFileObjects.add(javaFileObject);
            }
        }
        return javaFileObjects;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this._resourceResolver = resourceResolver;
    }

    private boolean hasPackageCapability(String packageName) {
        return true;
    }

    private void setOptions(List<String> options) {
        if (options == null) {
            return;
        }
        this._options.addAll(options);
        if (this._options.contains("-verbose")) {
            this._log.out = System.err;
        }
    }
}

