/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.Msg;
import ghidra.util.datastruct.LongArrayListIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

public class LongArrayList
implements List<Long>,
RandomAccess {
    public static final int MIN_SIZE = 4;
    private long[] longs;
    private int size = 0;

    public LongArrayList() {
        this.longs = new long[4];
    }

    public LongArrayList(long[] arr) {
        this.longs = arr;
        this.size = arr.length;
    }

    public LongArrayList(LongArrayList list) {
        this.size = list.size;
        this.longs = new long[Math.max(this.size, 4)];
        System.arraycopy(list.longs, 0, this.longs, 0, this.size);
    }

    public void add(long value) {
        this.add(this.size, value);
    }

    @Override
    public boolean add(Long value) {
        this.add(this.size, value);
        return true;
    }

    @Override
    public void add(int index, Long value) {
        this.add(index, (long)value);
    }

    @Override
    public void add(int index, long value) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Invalid index %d for list of size %d".formatted(index, this.size));
        }
        if (this.size == this.longs.length) {
            this.growArray();
        }
        try {
            System.arraycopy(this.longs, index, this.longs, index + 1, this.size - index);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        this.longs[index] = value;
        ++this.size;
    }

    @Override
    public Long remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index %d for list of size %d".formatted(index, this.size));
        }
        Long returnValue = this.longs[index];
        System.arraycopy(this.longs, index + 1, this.longs, index, this.size - index - 1);
        --this.size;
        if (this.size < this.longs.length / 4) {
            this.shrinkArray();
        }
        return returnValue;
    }

    @Override
    public Long get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index %d for list of size %d".formatted(index, this.size));
        }
        return this.longs[index];
    }

    public long getLongValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Invalid index %d for list of size %d".formatted(index, this.size));
        }
        return this.longs[index];
    }

    @Override
    public Long set(int index, Long value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Long oldValue = this.longs[index];
        this.longs[index] = value;
        return oldValue;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.longs = new long[4];
    }

    @Override
    public int size() {
        return this.size;
    }

    public Long[] toArray() {
        Long[] values = new Long[this.size];
        for (int i = 0; i < this.size; ++i) {
            values[i] = this.longs[i];
        }
        return values;
    }

    public long[] toLongArray() {
        return this.toLongArray(0, this.size());
    }

    public long[] toLongArray(int start, int length) {
        long[] tmparr = new long[length];
        System.arraycopy(this.longs, start, tmparr, 0, length);
        return tmparr;
    }

    private void growArray() {
        int len = this.longs.length;
        if (len == 0) {
            this.longs = new long[4];
            return;
        }
        long[] newlongs = new long[len * 2];
        System.arraycopy(this.longs, 0, newlongs, 0, len);
        this.longs = newlongs;
    }

    private void shrinkArray() {
        int newsize = this.longs.length / 2;
        if (newsize < 4) {
            return;
        }
        long[] newlongs = new long[newsize];
        System.arraycopy(this.longs, 0, newlongs, 0, this.size);
        this.longs = newlongs;
    }

    public void reverse() {
        int half = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < half) {
            long tmp = this.longs[i];
            this.longs[i] = this.longs[j];
            this.longs[j] = tmp;
            ++i;
            --j;
        }
    }

    @Override
    public boolean remove(Object value) {
        if (!(value instanceof Long)) {
            return false;
        }
        long longValue = (Long)value;
        for (int i = 0; i < this.size; ++i) {
            if (this.longs[i] != longValue) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object value) {
        if (!(value instanceof Long)) {
            return -1;
        }
        long longValue = (Long)value;
        for (int i = 0; i < this.size; ++i) {
            if (this.longs[i] != longValue) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Long> subList(int startIndex, int endIndex) {
        return new LongArraySubList(this, startIndex, endIndex);
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        int newSize = this.size + c.size();
        long[] newValues = new long[newSize];
        System.arraycopy(this.longs, 0, newValues, 0, index);
        Iterator<? extends Long> it = c.iterator();
        int nextIndex = index;
        while (it.hasNext()) {
            newValues[nextIndex++] = it.next();
        }
        System.arraycopy(this.longs, index, newValues, nextIndex, this.size - index);
        this.longs = newValues;
        this.size = newSize;
        return true;
    }

    @Override
    public boolean contains(Object value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new LongArrayListIterator(this, 0);
    }

    @Override
    public int lastIndexOf(Object value) {
        if (!(value instanceof Long)) {
            return -1;
        }
        long longValue = (Long)value;
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.longs[i] != longValue) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<Long> listIterator() {
        return new LongArrayListIterator(this, 0);
    }

    @Override
    public ListIterator<Long> listIterator(int index) {
        return new LongArrayListIterator(this, index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        long[] newValues = new long[this.longs.length];
        int newIndex = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!c.contains(this.longs[i])) continue;
            newValues[newIndex++] = this.longs[i];
        }
        this.longs = newValues;
        boolean changed = this.size == newIndex;
        this.size = newIndex;
        return changed;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            Long value = this.longs[i];
            a[i] = value;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public Long[] toArray(Long[] a) {
        Long[] values = new Long[this.size];
        for (int i = 0; i < this.size; ++i) {
            values[i] = this.longs[i];
        }
        return values;
    }

    static class LongArraySubList
    implements List<Long> {
        private int startIndex;
        private int endIndex;
        private LongArrayList backingList;

        LongArraySubList(LongArrayList list, int startIndex, int endIndex) {
            this.backingList = list;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @Override
        public boolean add(Long value) {
            this.backingList.add(this.endIndex++, value);
            return true;
        }

        public void add(long value) {
            this.backingList.add(this.endIndex++, value);
        }

        @Override
        public void add(int index, Long value) {
            if (index < 0 || index > this.endIndex - this.startIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.backingList.add(this.startIndex + index, value);
            ++this.endIndex;
        }

        @Override
        public void add(int index, long value) {
            if (index < 0 || index > this.endIndex - this.startIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.backingList.add(this.startIndex + index, value);
            ++this.endIndex;
        }

        @Override
        public Long remove(int index) {
            if (index < 0 || index >= this.endIndex - this.startIndex) {
                throw new IndexOutOfBoundsException();
            }
            --this.endIndex;
            return this.backingList.remove(this.startIndex + index);
        }

        @Override
        public Long get(int index) {
            if (index < 0 || index >= this.endIndex - this.startIndex) {
                throw new IndexOutOfBoundsException();
            }
            return this.backingList.get(this.startIndex + index);
        }

        @Override
        public void set(int index, long value) {
            if (index < 0 || index >= this.endIndex - this.startIndex) {
                throw new IndexOutOfBoundsException();
            }
            this.backingList.set(this.startIndex + index, value);
        }

        @Override
        public void clear() {
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                this.backingList.remove(this.startIndex);
            }
            this.endIndex = this.startIndex;
        }

        @Override
        public int size() {
            return this.endIndex - this.startIndex;
        }

        public Long[] toArray() {
            int size = this.size();
            Long[] values = new Long[size];
            for (int i = 0; i < size; ++i) {
                values[i] = this.get(i);
            }
            return values;
        }

        @Override
        public boolean remove(Object value) {
            if (!(value instanceof Long)) {
                return false;
            }
            int size = this.size();
            long longValue = (Long)value;
            for (int i = 0; i < size; ++i) {
                if (this.backingList.longs[this.startIndex + i] != longValue) continue;
                this.remove(i);
                return true;
            }
            return false;
        }

        public int getIndex(long value) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != value) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            this.backingList.addAll(this.endIndex, c);
            this.endIndex += c.size();
            return true;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            this.backingList.addAll(this.startIndex + index, c);
            this.endIndex += c.size();
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int indexOf(Object value) {
            if (!(value instanceof Long)) {
                return -1;
            }
            long longValue = (Long)value;
            for (int i = 0; i < this.size(); ++i) {
                if (this.backingList.longs[this.startIndex + i] != longValue) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<Long> iterator() {
            return new LongArrayListIterator(this, 0);
        }

        @Override
        public int lastIndexOf(Object value) {
            if (!(value instanceof Long)) {
                return -1;
            }
            long longValue = (Long)value;
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.backingList.longs[this.startIndex + i] != longValue) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new LongArrayListIterator(this, 0);
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            return new LongArrayListIterator(this, index);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean changed = false;
            Iterator<?> it = c.iterator();
            while (it.hasNext()) {
                if (!this.remove(it.next())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean changed = false;
            Iterator<Long> it = this.iterator();
            while (it.hasNext()) {
                Long value = it.next();
                if (c.contains(value)) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        @Override
        public Long set(int index, Long element) {
            if (index < 0 || index >= this.size()) {
                throw new IllegalArgumentException();
            }
            Long oldValue = this.get(index);
            this.backingList.set(this.startIndex + index, element);
            return oldValue;
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            return new LongArraySubList(this.backingList, this.startIndex + fromIndex, this.startIndex + toIndex);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < this.size()) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
            }
            for (int i = 0; i < this.size(); ++i) {
                a[i] = this.get(i);
            }
            if (a.length > this.size()) {
                a[this.size()] = null;
            }
            return a;
        }
    }
}

