/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.manager;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.MonitorContendedEnteredEvent;
import com.sun.jdi.event.MonitorWaitEvent;
import com.sun.jdi.event.MonitorWaitedEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import ghidra.async.AsyncReference;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListener;
import ghidra.dbg.jdi.manager.JdiReason;
import ghidra.dbg.jdi.manager.JdiStateListener;
import ghidra.dbg.jdi.manager.JdiThreadInfo;
import ghidra.dbg.jdi.manager.impl.DebugStatus;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class JdiEventHandler
implements Runnable {
    volatile boolean connected = true;
    boolean completed = false;
    String shutdownMessageKey;
    private VirtualMachine vm;
    private Thread handlerThread;
    private JdiEventHandler global;
    protected final AsyncReference<Integer, JdiCause> state = new AsyncReference((Object)5);
    public final Set<JdiEventsListener> listenersEvent = new HashSet<JdiEventsListener>();
    protected final ExecutorService eventThread = Executors.newSingleThreadExecutor();
    private boolean vmDied = false;

    public JdiEventHandler() {
    }

    public JdiEventHandler(VirtualMachine vm, JdiEventHandler global) {
        this.vm = vm;
        this.global = global;
        this.state.filter(this::stateFilter);
    }

    public void start() {
        this.handlerThread = new Thread((Runnable)this, "event-handler");
        this.handlerThread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.handlerThread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public CompletableFuture<Void> event(Runnable r, String text) {
        return CompletableFuture.runAsync(r, this.eventThread).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Error in event callback:", (Throwable)ex);
            return (Void)ExceptionUtils.rethrow((Throwable)ex);
        });
    }

    public void addStateListener(JdiStateListener listener) {
        this.state.addChangeListener((TriConsumer)listener);
    }

    public void removeStateListener(JdiStateListener listener) {
        this.state.removeChangeListener((TriConsumer)listener);
    }

    public void addEventsListener(JdiEventsListener listener) {
        this.listenersEvent.add(listener);
    }

    public void removeEventsListener(JdiEventsListener listener) {
        this.listenersEvent.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                DebugStatus status = DebugStatus.BREAK;
                this.state.set((Object)4, (Object)JdiCause.Causes.UNCLAIMED);
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    Event nextEvent = it.nextEvent();
                    this.global.processEvent(nextEvent);
                    status = DebugStatus.update(this.processEvent(nextEvent));
                }
                if (status.equals((Object)DebugStatus.GO)) {
                    this.state.set((Object)1, (Object)JdiCause.Causes.UNCLAIMED);
                    eventSet.resume();
                    continue;
                }
                if (eventSet.suspendPolicy() != 2) continue;
                this.setCurrentThread(eventSet);
                for (JdiEventsListener listener : this.listenersEvent) {
                    listener.processStop(eventSet, JdiCause.Causes.UNCLAIMED);
                }
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
        JdiEventHandler jdiEventHandler = this;
        synchronized (jdiEventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private DebugStatus processEvent(Event event) {
        Event event2 = event;
        Objects.requireNonNull(event2);
        Event event3 = event2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExceptionEvent.class, BreakpointEvent.class, AccessWatchpointEvent.class, ModificationWatchpointEvent.class, WatchpointEvent.class, StepEvent.class, MethodEntryEvent.class, MethodExitEvent.class, MonitorContendedEnteredEvent.class, MonitorContendedEnterEvent.class, MonitorWaitedEvent.class, MonitorWaitEvent.class, ClassPrepareEvent.class, ClassUnloadEvent.class, ThreadStartEvent.class, ThreadDeathEvent.class, VMStartEvent.class, VMDisconnectEvent.class, VMDeathEvent.class}, (Object)event3, n)) {
            case 0 -> {
                ExceptionEvent ev = (ExceptionEvent)event3;
                yield this.processException(ev);
            }
            case 1 -> {
                BreakpointEvent ev = (BreakpointEvent)event3;
                yield this.processBreakpoint(ev);
            }
            case 2 -> {
                AccessWatchpointEvent ev = (AccessWatchpointEvent)event3;
                yield this.processAccessWatchpoint(ev);
            }
            case 3 -> {
                ModificationWatchpointEvent ev = (ModificationWatchpointEvent)event3;
                yield this.processWatchpointModification(ev);
            }
            case 4 -> {
                WatchpointEvent ev = (WatchpointEvent)event3;
                yield this.processWatchpoint(ev);
            }
            case 5 -> {
                StepEvent ev = (StepEvent)event3;
                yield this.processStep(ev);
            }
            case 6 -> {
                MethodEntryEvent ev = (MethodEntryEvent)event3;
                yield this.processMethodEntry(ev);
            }
            case 7 -> {
                MethodExitEvent ev = (MethodExitEvent)event3;
                yield this.processMethodExit(ev);
            }
            case 8 -> {
                MonitorContendedEnteredEvent ev = (MonitorContendedEnteredEvent)event3;
                yield this.processMCEntered(ev);
            }
            case 9 -> {
                MonitorContendedEnterEvent ev = (MonitorContendedEnterEvent)event3;
                yield this.processMCEnter(ev);
            }
            case 10 -> {
                MonitorWaitedEvent ev = (MonitorWaitedEvent)event3;
                yield this.processMonitorWaited(ev);
            }
            case 11 -> {
                MonitorWaitEvent ev = (MonitorWaitEvent)event3;
                yield this.processMonitorWait(ev);
            }
            case 12 -> {
                ClassPrepareEvent ev = (ClassPrepareEvent)event3;
                yield this.processClassPrepare(ev);
            }
            case 13 -> {
                ClassUnloadEvent ev = (ClassUnloadEvent)event3;
                yield this.processClassUnload(ev);
            }
            case 14 -> {
                ThreadStartEvent ev = (ThreadStartEvent)event3;
                yield this.processThreadStart(ev);
            }
            case 15 -> {
                ThreadDeathEvent ev = (ThreadDeathEvent)event3;
                yield this.processThreadDeath(ev);
            }
            case 16 -> {
                VMStartEvent ev = (VMStartEvent)event3;
                yield this.processVMStart(ev);
            }
            case 17 -> {
                VMDisconnectEvent ev = (VMDisconnectEvent)event3;
                yield this.processVMDisconnect(ev);
            }
            case 18 -> {
                VMDeathEvent ev = (VMDeathEvent)event3;
                yield this.processVMDeath(ev);
            }
            default -> this.processUnknown(event);
        };
    }

    private DebugStatus processUnknown(Event event) {
        System.err.println("Unknown event: " + String.valueOf(event));
        return null;
    }

    private DebugStatus handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            return this.processVMDeath((VMDeathEvent)event);
        }
        if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            if (!this.vmDied) {
                this.processVMDisconnect((VMDisconnectEvent)event);
            }
            DebugStatus status = DebugStatus.NO_CHANGE;
            for (JdiEventsListener listener : this.listenersEvent) {
                status = this.update(status, listener.processShutdown(event, JdiCause.Causes.UNCLAIMED));
            }
            return status;
        }
        throw new InternalError();
    }

    synchronized void handleDisconnectedException() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    this.handleExitEvent((Event)iter.next());
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InternalError internalError) {
            }
        }
    }

    private ThreadReference eventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private void setCurrentThread(EventSet set) {
        ThreadReference thread;
        if (set.size() > 0) {
            Event event = (Event)set.iterator().next();
            thread = this.eventThread(event);
        } else {
            thread = null;
        }
        this.setCurrentThread(thread);
    }

    private void setCurrentThread(ThreadReference thread) {
        JdiThreadInfo.invalidateAll();
        JdiThreadInfo.setCurrentThread(thread);
    }

    private DebugStatus update(DebugStatus status, DebugStatus update) {
        if (update == null) {
            update = DebugStatus.BREAK;
        }
        return update.equals((Object)DebugStatus.NO_CHANGE) ? status : update;
    }

    protected DebugStatus processBreakpoint(BreakpointEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.breakpointHit(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processException(ExceptionEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.exceptionHit(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMethodEntry(MethodEntryEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.methodEntry(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMethodExit(MethodExitEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.methodExit(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processClassPrepare(ClassPrepareEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.classPrepare(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processClassUnload(ClassUnloadEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.classUnload(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMCEntered(MonitorContendedEnteredEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.monitorContendedEntered(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMCEnter(MonitorContendedEnterEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.monitorContendedEnter(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMonitorWaited(MonitorWaitedEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.monitorWaited(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processMonitorWait(MonitorWaitEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.monitorWait(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processStep(StepEvent evt) {
        evt.request().disable();
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.stepComplete(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processWatchpoint(WatchpointEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.watchpointHit(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processAccessWatchpoint(AccessWatchpointEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.accessWatchpointHit(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processWatchpointModification(ModificationWatchpointEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.watchpointModified(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processThreadDeath(ThreadDeathEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.threadExited(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    public DebugStatus processThreadStateChanged(ThreadReference thread, int threadState, JdiReason reason) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.threadStateChanged(thread, threadState, JdiCause.Causes.UNCLAIMED, reason));
        }
        return status;
    }

    protected DebugStatus processThreadStart(ThreadStartEvent evt) {
        JdiThreadInfo.addThread(evt.thread());
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.threadStarted(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processVMDeath(VMDeathEvent evt) {
        this.shutdownMessageKey = "The application exited";
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.vmDied(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processVMDisconnect(VMDisconnectEvent evt) {
        this.shutdownMessageKey = "The application has been disconnected";
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.vmDisconnected(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    protected DebugStatus processVMStart(VMStartEvent evt) {
        DebugStatus status = DebugStatus.NO_CHANGE;
        for (JdiEventsListener listener : this.listenersEvent) {
            status = this.update(status, listener.vmStarted(evt, JdiCause.Causes.UNCLAIMED));
        }
        return status;
    }

    public Integer getState() {
        return (Integer)this.state.get();
    }

    public void setState(Integer val, JdiCause cause) {
        this.state.set((Object)val, (Object)cause);
    }

    private Integer stateFilter(Integer cur, Integer set, JdiCause cause) {
        if (set == null) {
            return cur;
        }
        return set;
    }
}

