/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;

public class MappedDataEntry
extends MappedEntry {
    private Data data;

    public MappedDataEntry(HighSymbol sym) {
        super(sym);
    }

    public MappedDataEntry(HighSymbol sym, VariableStorage store, Data d) {
        super(sym, store, null);
        this.data = d;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        super.decode(decoder);
        this.data = this.symbol.getProgram().getListing().getDataAt(this.storage.getMinAddress());
    }

    @Override
    public int getMutability() {
        if (this.data.isVolatile()) {
            return 1;
        }
        if (this.data.isConstant()) {
            return 2;
        }
        if (this.data.isWritable()) {
            return 0;
        }
        return super.getMutability();
    }
}

