/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.QualifierFilter;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class PositionMatchFilter
implements QualifierFilter {
    private int position;

    public PositionMatchFilter(int pos) {
        this.position = pos;
    }

    @Override
    public QualifierFilter clone() {
        return new PositionMatchFilter(this.position);
    }

    @Override
    public boolean isEquivalent(QualifierFilter op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        PositionMatchFilter otherFilter = (PositionMatchFilter)op;
        return this.position == otherFilter.position;
    }

    @Override
    public boolean filter(PrototypePieces proto, int pos) {
        return pos == this.position;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_POSITION);
        encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, this.position);
        encoder.closeElement(ElementId.ELEM_POSITION);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_POSITION.name()});
        this.position = SpecXmlUtils.decodeInt((String)elem.getAttribute(AttributeId.ATTRIB_INDEX.name()));
        parser.end(elem);
    }
}

