/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DBStringMapAdapter {
    private static final Field[] COL_FIELDS = new Field[]{StringField.INSTANCE};
    private static final String[] COL_TYPES = new String[]{"Value"};
    private static final Schema SCHEMA = new Schema(0, (Field)StringField.INSTANCE, "Key", COL_FIELDS, COL_TYPES);
    private Table table;

    public DBStringMapAdapter(DBHandle dbHandle, String tableName, boolean create) throws IOException {
        if (create) {
            this.table = dbHandle.createTable(tableName, SCHEMA);
        } else {
            this.table = dbHandle.getTable(tableName);
            if (this.table == null) {
                throw new IOException("Table not found: " + tableName);
            }
        }
    }

    public void put(String key, String value) throws IOException {
        if (StringUtils.equals((CharSequence)value, (CharSequence)this.get(key))) {
            return;
        }
        DBRecord record = SCHEMA.createRecord((Field)new StringField(key));
        record.setString(0, value);
        this.table.putRecord(record);
    }

    public String get(String key) throws IOException {
        DBRecord record = this.table.getRecord((Field)new StringField(key));
        return record != null ? record.getString(0) : null;
    }

    public int getInt(String key, int defaultValue) throws IOException {
        DBRecord record = this.table.getRecord((Field)new StringField(key));
        if (record != null) {
            try {
                return Integer.valueOf(record.getString(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) throws IOException {
        DBRecord record = this.table.getRecord((Field)new StringField(key));
        if (record != null) {
            return Boolean.valueOf(record.getString(0));
        }
        return defaultValue;
    }

    public Set<String> keySet() throws IOException {
        HashSet<String> set = new HashSet<String>();
        DBFieldIterator keyIter = this.table.fieldKeyIterator();
        while (keyIter.hasNext()) {
            set.add(keyIter.next().getString());
        }
        return set;
    }

    public void delete(String key) throws IOException {
        this.table.deleteRecord((Field)new StringField(key));
    }
}

