/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnknownValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private boolean priorityCompat = false;

    public UnknownValue() {
        super(CSSValue.Type.UNKNOWN);
    }

    protected UnknownValue(UnknownValue copied) {
        super(copied);
        this.setCssText(copied.getCssText());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.checkModifiableProperty();
        this.setPlainCssText(cssText);
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)this.getCssText());
    }

    public boolean isPriorityCompat() {
        return this.priorityCompat;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        if (syntax != null && syntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.PENDING;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownValue other = (UnknownValue)obj;
        return this.getCssText().equals(other.getCssText());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getCssText().hashCode();
        return result;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnknownValue clone() {
        return new UnknownValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            String text;
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
            switch (lunit.getLexicalUnitType()) {
                case OPERATOR_EXP: {
                    text = "^";
                    break;
                }
                case OPERATOR_GE: {
                    text = ">=";
                    break;
                }
                case OPERATOR_GT: {
                    text = ">";
                    break;
                }
                case OPERATOR_LE: {
                    text = "<=";
                    break;
                }
                case OPERATOR_LT: {
                    text = "<";
                    break;
                }
                case OPERATOR_MINUS: {
                    text = "-";
                    break;
                }
                case OPERATOR_MOD: {
                    text = "%";
                    break;
                }
                case OPERATOR_MULTIPLY: {
                    text = "*";
                    break;
                }
                case OPERATOR_PLUS: {
                    text = "+";
                    break;
                }
                case OPERATOR_TILDE: {
                    text = "~";
                    break;
                }
                case OPERATOR_COLON: {
                    text = ":";
                    break;
                }
                case OPERATOR_SEMICOLON: {
                    text = ";";
                    break;
                }
                case COMPAT_PRIO: {
                    UnknownValue.this.priorityCompat = true;
                }
                case COMPAT_IDENT: {
                    text = lunit.toString();
                    this.nextLexicalUnit = null;
                    break;
                }
                default: {
                    throw new DOMSyntaxException("Unsuitable value: " + lunit.toString());
                }
            }
            UnknownValue.this.setPlainCssText(text);
        }
    }
}

