/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.windows.BITMAPINFOHEADER;
import jogamp.nativewindow.windows.RGBQUAD;

public class BITMAPINFO {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] BITMAPINFO_size = new int[]{44, 44, 44, 44, 44, 44, 44, 44, 44, 44};
    private static final int[] bmiHeader_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] bmiHeader_size = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};
    private static final int[] bmiColors_offset = new int[]{40, 40, 40, 40, 40, 40, 40, 40, 40, 40};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return BITMAPINFO_size[mdIdx];
    }

    public static BITMAPINFO create() {
        return BITMAPINFO.create(Buffers.newDirectByteBuffer((int)BITMAPINFO.size()));
    }

    public static BITMAPINFO create(ByteBuffer byteBuffer) {
        return new BITMAPINFO(byteBuffer);
    }

    public static BITMAPINFO derefPointer(long l) {
        return BITMAPINFO.create(ElementBuffer.derefPointer((int)BITMAPINFO.size(), (long)l, (int)1).getByteBuffer());
    }

    BITMAPINFO(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[BITMAPINFO.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final BITMAPINFOHEADER getBmiHeader() {
        return BITMAPINFOHEADER.create(this.accessor.slice(bmiHeader_offset[mdIdx], bmiHeader_size[mdIdx]));
    }

    public static int getBmiColorsElemCount() {
        return 1;
    }

    public final RGBQUAD getBmiColors() {
        return RGBQUAD.create(ElementBuffer.wrap((int)RGBQUAD.size(), (ByteBuffer)this.getBuffer(), (int)bmiColors_offset[mdIdx], (int)1).getByteBuffer());
    }
}

