// SPDX-FileCopyrightText: 2021 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: LGPL-3.0-or-later

import QtQuick
import org.deepin.dtk 1.0 as D
import org.deepin.dtk.style 1.0 as DS

ToolTip {
    id: control
    property Item target

    x: 0
    y: target ? target.height + DS.Style.control.spacing : 0
    topPadding: DS.Style.alertToolTip.verticalPadding
    bottomPadding: DS.Style.alertToolTip.verticalPadding
    leftPadding: DS.Style.alertToolTip.horizontalPadding
    rightPadding: DS.Style.alertToolTip.horizontalPadding
    implicitWidth: Math.min(DS.Style.control.implicitWidth(control), target.width)
    implicitHeight: DS.Style.control.implicitHeight(control)
    margins: 0
    closePolicy: Popup.NoAutoClose

    background: FloatingPanel {
        radius: DS.Style.alertToolTip.radius
        implicitWidth: DS.Style.alertToolTip.width
        implicitHeight: DS.Style.alertToolTip.height
        backgroundColor: DS.Style.alertToolTip.background
        insideBorderColor: DS.Style.alertToolTip.insideBorder
        outsideBorderColor: DS.Style.alertToolTip.outsideBorder
    }

    contentItem: Text {
        property D.Palette textColor: DS.Style.alertToolTip.text
        horizontalAlignment: Text.AlignLeft
        verticalAlignment: Text.AlignVCenter
        text: control.text
        font: control.font
        color: D.ColorSelector.textColor
        wrapMode: Text.Wrap
    }

    enter: Transition {
        // TODO: Transparency causes tooltips to appear through the window background - temporarily removed
        // NumberAnimation { properties: "opacity"; from: 0.0; to: 1.0; duration: 200 }
        NumberAnimation { properties: "y"; from: control.target.height; to: control.target.height + DS.Style.control.spacing; duration: 200 }
    }

    exit: Transition {
        // NumberAnimation { properties: "opacity"; from: 1.0; to: 0.0 }
        NumberAnimation { properties: "y"; from: control.target.height + DS.Style.control.spacing ; to: control.target.height }
    }

    BoxShadow {
        id: line
        property D.Palette dropShadowColor: DS.Style.alertToolTip.connecterdropShadow
        property D.Palette backgroundColor: DS.Style.alertToolTip.connecterBackground
        property D.Palette borderColor: DS.Style.control.border
        y: - height * (0.75) - control.topMargin - control.topPadding
        width: DS.Style.alertToolTip.connectorWidth
        height: DS.Style.alertToolTip.connectorHeight
        shadowBlur: 4
        shadowOffsetY: 2
        shadowColor: D.ColorSelector.dropShadowColor
        cornerRadius: DS.Style.control.radius

        Rectangle {
            anchors.fill: parent
            color: line.D.ColorSelector.backgroundColor
            border.color: line.D.ColorSelector.borderColor
            border.width: 1
        }
    }
}
