import { Command } from '@oclif/core';
/**
 * Comando per creare pacchetti Debian
 */
export default class Deb extends Command {
    here: string;
    pathSource: string;
    static args: {
        pathSource: import("@oclif/core/interfaces").Arg<string | undefined, Record<string, unknown>>;
    };
    static description: string;
    static flags: {
        help: import("@oclif/core/interfaces").BooleanFlag<void>;
        all: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        release: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        manpages: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        verbose: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    static summary: string;
    /**
     * Metodo principale eseguito dal comando
     */
    run(): Promise<void>;
}
