; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=GFX6 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -global-isel -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define float @v_pow_f32(float %x, float %y) {
; GFX6-LABEL: v_pow_f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %pow = call float @llvm.pow.f32(float %x, float %y)
  ret float %pow
}

define <2 x float> @v_pow_v2f32(<2 x float> %x, <2 x float> %y) {
; GFX6-LABEL: v_pow_v2f32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v4, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v4
; GFX6-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v4
; GFX6-NEXT:    v_lshlrev_b32_e32 v5, 5, v5
; GFX6-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v5
; GFX6-NEXT:    v_lshlrev_b32_e32 v4, 5, v4
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v1, v4
; GFX6-NEXT:    v_log_f32_e32 v1, v1
; GFX6-NEXT:    v_mov_b32_e32 v5, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v6
; GFX6-NEXT:    v_cndmask_b32_e64 v5, 0, v5, s[4:5]
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX6-NEXT:    v_sub_f32_e32 v1, v1, v5
; GFX6-NEXT:    v_mov_b32_e32 v6, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e32 v1, v1, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v7, 0, v6, vcc
; GFX6-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v2
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v7
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, v6, s[4:5]
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_exp_f32_e32 v1, v1
; GFX6-NEXT:    v_not_b32_e32 v4, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v4, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, v4, s[4:5]
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_v2f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v4, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v4
; GFX8-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX8-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 5, v5
; GFX8-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 5, v4
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_ldexp_f32 v1, v1, v4
; GFX8-NEXT:    v_log_f32_e32 v1, v1
; GFX8-NEXT:    v_mov_b32_e32 v5, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v6
; GFX8-NEXT:    v_cndmask_b32_e64 v5, 0, v5, s[4:5]
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX8-NEXT:    v_sub_f32_e32 v1, v1, v5
; GFX8-NEXT:    v_mov_b32_e32 v6, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v1, v1, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v7, 0, v6, vcc
; GFX8-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v2
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v7
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, v6, s[4:5]
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX8-NEXT:    v_exp_f32_e32 v1, v1
; GFX8-NEXT:    v_not_b32_e32 v4, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v4, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, v4, s[4:5]
; GFX8-NEXT:    v_ldexp_f32 v1, v1, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_v2f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v4, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v4
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, 1, vcc
; GFX9-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v4
; GFX9-NEXT:    v_lshlrev_b32_e32 v5, 5, v5
; GFX9-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 5, v4
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_ldexp_f32 v1, v1, v4
; GFX9-NEXT:    v_log_f32_e32 v1, v1
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v6
; GFX9-NEXT:    v_cndmask_b32_e64 v5, 0, v5, s[4:5]
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX9-NEXT:    v_sub_f32_e32 v1, v1, v5
; GFX9-NEXT:    v_mov_b32_e32 v6, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v1, v1, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v7, 0, v6, vcc
; GFX9-NEXT:    v_cmp_lt_f32_e64 s[4:5], v1, v2
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v7
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, v6, s[4:5]
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX9-NEXT:    v_exp_f32_e32 v1, v1
; GFX9-NEXT:    v_not_b32_e32 v4, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v4, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, v4, s[4:5]
; GFX9-NEXT:    v_ldexp_f32 v1, v1, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_v2f32:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, 0x800000, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 1, s4
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 5, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 5, v5
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v4
; GFX10-NEXT:    v_ldexp_f32 v1, v1, v5
; GFX10-NEXT:    v_cndmask_b32_e64 v4, 0, 0x42000000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v5, 0, 0x42000000, s4
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_log_f32_e32 v1, v1
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v4
; GFX10-NEXT:    v_sub_f32_e32 v1, v1, v5
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e32 v1, v1, v3
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, 0xc2fc0000, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, 0, 0x42800000, s4
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_add_f32_e32 v1, v1, v3
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v3, 0, 0xffffffc0, s4
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f32_e32 v1, v1
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX10-NEXT:    v_ldexp_f32 v1, v1, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_v2f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, 0x800000, v1
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v5, 0, 1, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc_lo
; GFX11-NEXT:    v_lshlrev_b32_e32 v5, 5, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_ldexp_f32 v1, v1, v5
; GFX11-NEXT:    v_cndmask_b32_e64 v5, 0, 0x42000000, s0
; GFX11-NEXT:    v_log_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_sub_f32 v1, v1, v5 :: v_dual_lshlrev_b32 v4, 5, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v4, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v1, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, 0xc2fc0000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 0x42800000, s0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_dual_sub_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v3
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v3, 0, 0xffffffc0, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v1, v1
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v1, v1, v3
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %pow = call <2 x float> @llvm.pow.v2f32(<2 x float> %x, <2 x float> %y)
  ret <2 x float> %pow
}

define half @v_pow_f16(half %x, half %y) {
; GFX6-LABEL: v_pow_f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v3, 0x42800000
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_log_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_log_f16_e32 v0, v0
; GFX9-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    v_exp_f16_e32 v0, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_log_f16_e32 v0, v0
; GFX10-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f16_e32 v0, v0
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_pow_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v1.l
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_pow_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %pow = call half @llvm.pow.f16(half %x, half %y)
  ret half %pow
}

define <2 x half> @v_pow_v2f16(<2 x half> %x, <2 x half> %y) {
; GFX6-LABEL: v_pow_v2f16:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_mov_b32_e32 v4, 0xc2fc0000
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v5, 0x42800000
; GFX6-NEXT:    v_log_f32_e32 v1, v1
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v5, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v3
; GFX6-NEXT:    v_not_b32_e32 v3, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v6, 0, v3, vcc
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_legacy_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v1, v4
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v5, vcc
; GFX6-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_exp_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v3, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v6
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_v2f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_log_f16_e32 v2, v0
; GFX8-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v1, v1
; GFX8-NEXT:    v_exp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_log_f16_e32 v2, v0
; GFX9-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX9-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX9-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    v_exp_f16_e32 v1, v1
; GFX9-NEXT:    v_exp_f16_e32 v0, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_v2f16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_log_f16_e32 v2, v0
; GFX10-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX10-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX10-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f16_e32 v1, v2
; GFX10-NEXT:    v_exp_f16_e32 v0, v0
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_pow_v2f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v2, v1.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v1.h
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v3, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_mul_dx9_zero_f32 v2, v3, v2 :: v_dual_mul_dx9_zero_f32 v1, v0, v1
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.h, v1
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_pow_v2f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v2, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_mul_dx9_zero_f32 v1, v2, v1 :: v_dual_mul_dx9_zero_f32 v0, v0, v3
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %pow = call <2 x half> @llvm.pow.v2f16(<2 x half> %x, <2 x half> %y)
  ret <2 x half> %pow
}

define <2 x half> @v_pow_v2f16_fneg_lhs(<2 x half> %x, <2 x half> %y) {
; GFX6-LABEL: v_pow_v2f16_fneg_lhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_log_f32_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v4, 0x42800000
; GFX6-NEXT:    v_mul_legacy_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v1, v2
; GFX6-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; GFX6-NEXT:    v_add_f32_e32 v1, v1, v5
; GFX6-NEXT:    v_not_b32_e32 v5, 63
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v4, vcc
; GFX6-NEXT:    v_exp_f32_e32 v1, v1
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_exp_f32_e32 v2, v0
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v1, v6
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v5, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v2, v1
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_v2f16_fneg_lhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX8-NEXT:    v_log_f16_e32 v2, v0
; GFX8-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v1, v1
; GFX8-NEXT:    v_exp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_v2f16_fneg_lhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX9-NEXT:    v_log_f16_e32 v2, v0
; GFX9-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX9-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX9-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    v_exp_f16_e32 v1, v1
; GFX9-NEXT:    v_exp_f16_e32 v0, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_v2f16_fneg_lhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX10-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_log_f16_e32 v2, v0
; GFX10-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX10-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX10-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f16_e32 v1, v2
; GFX10-NEXT:    v_exp_f16_e32 v0, v0
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_pow_v2f16_fneg_lhs:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v2, v1.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v1.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v3, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_mul_dx9_zero_f32 v2, v3, v2 :: v_dual_mul_dx9_zero_f32 v1, v0, v1
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.h, v1
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_pow_v2f16_fneg_lhs:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v2, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_dual_mul_dx9_zero_f32 v1, v2, v1 :: v_dual_mul_dx9_zero_f32 v0, v0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %x.fneg = fneg <2 x half> %x
  %pow = call <2 x half> @llvm.pow.v2f16(<2 x half> %x.fneg, <2 x half> %y)
  ret <2 x half> %pow
}

define <2 x half> @v_pow_v2f16_fneg_rhs(<2 x half> %x, <2 x half> %y) {
; GFX6-LABEL: v_pow_v2f16_fneg_rhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_or_b32_e32 v2, v3, v2
; GFX6-NEXT:    v_xor_b32_e32 v2, 0x80008000, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX6-NEXT:    v_log_f32_e32 v1, v1
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v3
; GFX6-NEXT:    v_mov_b32_e32 v3, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v4, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v5
; GFX6-NEXT:    v_not_b32_e32 v5, 63
; GFX6-NEXT:    v_mul_legacy_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v1, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v4, vcc
; GFX6-NEXT:    v_add_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_exp_f32_e32 v1, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v5, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v6
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_v2f16_fneg_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_log_f16_e32 v2, v0
; GFX8-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX8-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v1, v2
; GFX8-NEXT:    v_exp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_v2f16_fneg_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_log_f16_e32 v2, v0
; GFX9-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX9-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX9-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX9-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    v_exp_f16_e32 v1, v2
; GFX9-NEXT:    v_exp_f16_e32 v0, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_v2f16_fneg_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_log_f16_e32 v2, v0
; GFX10-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX10-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX10-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX10-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f16_e32 v1, v2
; GFX10-NEXT:    v_exp_f16_e32 v0, v0
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_pow_v2f16_fneg_rhs:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v2, v1.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v1.h
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v3, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_mul_dx9_zero_f32 v2, v3, v2 :: v_dual_mul_dx9_zero_f32 v1, v0, v1
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.h, v1
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_pow_v2f16_fneg_rhs:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v2, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_mul_dx9_zero_f32 v1, v2, v1 :: v_dual_mul_dx9_zero_f32 v0, v0, v3
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %y.fneg = fneg <2 x half> %y
  %pow = call <2 x half> @llvm.pow.v2f16(<2 x half> %x, <2 x half> %y.fneg)
  ret <2 x half> %pow
}

define <2 x half> @v_pow_v2f16_fneg_lhs_rhs(<2 x half> %x, <2 x half> %y) {
; GFX6-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX6-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX6-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX6-NEXT:    v_cvt_f32_f16_e32 v3, v0
; GFX6-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX6-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX6-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX6-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-NEXT:    v_cvt_f32_f16_e32 v2, v1
; GFX6-NEXT:    v_log_f32_e32 v3, v3
; GFX6-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX6-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mul_legacy_f32_e32 v2, v3, v2
; GFX6-NEXT:    v_mov_b32_e32 v3, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v4, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v2, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; GFX6-NEXT:    v_add_f32_e32 v2, v2, v5
; GFX6-NEXT:    v_not_b32_e32 v5, 63
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v6, 0, v5, vcc
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v3
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v4, vcc
; GFX6-NEXT:    v_exp_f32_e32 v2, v2
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v1, v0
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v6
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v5, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX8-NEXT:    v_log_f16_e32 v2, v0
; GFX8-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX8-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX8-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v1, v2
; GFX8-NEXT:    v_exp_f16_sdwa v0, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; GFX8-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX9-NEXT:    v_log_f16_e32 v2, v0
; GFX9-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX9-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX9-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX9-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX9-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-NEXT:    v_exp_f16_e32 v1, v2
; GFX9-NEXT:    v_exp_f16_e32 v0, v0
; GFX9-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX10-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX10-NEXT:    v_log_f16_e32 v2, v0
; GFX10-NEXT:    v_log_f16_sdwa v0, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v3, v1
; GFX10-NEXT:    v_cvt_f32_f16_sdwa v1, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
; GFX10-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX10-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX10-NEXT:    v_mul_legacy_f32_e32 v2, v2, v3
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX10-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX10-NEXT:    v_exp_f16_e32 v1, v2
; GFX10-NEXT:    v_exp_f16_e32 v0, v0
; GFX10-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX10-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v2, v1.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v1.h
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v3, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_mul_dx9_zero_f32 v2, v3, v2 :: v_dual_mul_dx9_zero_f32 v1, v0, v1
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.h, v1
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.h, v0.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_pow_v2f16_fneg_lhs_rhs:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v2, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_mul_dx9_zero_f32 v1, v2, v1 :: v_dual_mul_dx9_zero_f32 v0, v0, v3
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %x.fneg = fneg <2 x half> %x
  %y.fneg = fneg <2 x half> %y
  %pow = call <2 x half> @llvm.pow.v2f16(<2 x half> %x.fneg, <2 x half> %y.fneg)
  ret <2 x half> %pow
}

; FIXME
; define double @v_pow_f64(double %x, double %y) {
;   %pow = call double @llvm.pow.f64(double %x, double %y)
;   ret double %pow
; }

define float @v_pow_f32_fabs_lhs(float %x, float %y) {
; GFX6-LABEL: v_pow_f32_fabs_lhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e64 v0, |v0|, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32_fabs_lhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32_fabs_lhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32_fabs_lhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, 0x800000, |v0|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s4
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32_fabs_lhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, 0x800000, |v0|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s0
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call float @llvm.fabs.f32(float %x)
  %pow = call float @llvm.pow.f32(float %fabs.x, float %y)
  ret float %pow
}

define float @v_pow_f32_fabs_rhs(float %x, float %y) {
; GFX6-LABEL: v_pow_f32_fabs_rhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32_fabs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32_fabs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32_fabs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32_fabs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_dx9_zero_f32_e64 v0, v0, |v1|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %pow = call float @llvm.pow.f32(float %x, float %fabs.y)
  ret float %pow
}

define float @v_pow_f32_fabs_lhs_rhs(float %x, float %y) {
; GFX6-LABEL: v_pow_f32_fabs_lhs_rhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e64 v0, |v0|, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32_fabs_lhs_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32_fabs_lhs_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e64 vcc, |v0|, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32_fabs_lhs_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, 0x800000, |v0|
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s4
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e64 v0, v0, |v1|
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32_fabs_lhs_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, 0x800000, |v0|
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_ldexp_f32 v0, |v0|, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s0
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_dx9_zero_f32_e64 v0, v0, |v1|
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call float @llvm.fabs.f32(float %x)
  %fabs.y = call float @llvm.fabs.f32(float %y)
  %pow = call float @llvm.pow.f32(float %fabs.x, float %fabs.y)
  ret float %pow
}

define amdgpu_ps float @v_pow_f32_sgpr_vgpr(float inreg %x, float %y) {
; GFX6-LABEL: v_pow_f32_sgpr_vgpr:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v1
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v1, s0, v1
; GFX6-NEXT:    v_log_f32_e32 v1, v1
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v1, v1, v2
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v1, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: v_pow_f32_sgpr_vgpr:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v1
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX8-NEXT:    v_ldexp_f32 v1, s0, v1
; GFX8-NEXT:    v_log_f32_e32 v1, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v1, v1, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v1, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: v_pow_f32_sgpr_vgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX9-NEXT:    v_ldexp_f32 v1, s0, v1
; GFX9-NEXT:    v_log_f32_e32 v1, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v1, v1, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v1, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: v_pow_f32_sgpr_vgpr:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_cmp_gt_f32_e64 s1, 0x800000, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s1
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s1
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX10-NEXT:    v_ldexp_f32 v1, s0, v1
; GFX10-NEXT:    v_log_f32_e32 v1, v1
; GFX10-NEXT:    v_sub_f32_e32 v1, v1, v2
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v1, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: v_pow_f32_sgpr_vgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cmp_gt_f32_e64 s1, 0x800000, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s1
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s1
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_ldexp_f32 v1, s0, v1
; GFX11-NEXT:    v_log_f32_e32 v1, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v1, v1, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v1, v0
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    ; return to shader part epilog
  %pow = call float @llvm.pow.f32(float %x, float %y)
  ret float %pow
}

define amdgpu_ps float @v_pow_f32_vgpr_sgpr(float %x, float inreg %y) {
; GFX6-LABEL: v_pow_f32_vgpr_sgpr:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, s0, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: v_pow_f32_vgpr_sgpr:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, s0, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: v_pow_f32_vgpr_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, s0, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: v_pow_f32_vgpr_sgpr:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42000000, vcc_lo
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, s0, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: v_pow_f32_vgpr_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 5, v1
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, s0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    ; return to shader part epilog
  %pow = call float @llvm.pow.f32(float %x, float %y)
  ret float %pow
}

define amdgpu_ps float @v_pow_f32_sgpr_sgpr(float inreg %x, float inreg %y) {
; GFX6-LABEL: v_pow_f32_sgpr_sgpr:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    v_mov_b32_e32 v0, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v0
; GFX6-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX6-NEXT:    v_ldexp_f32_e32 v0, s0, v0
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, s1, v0
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    ; return to shader part epilog
;
; GFX8-LABEL: v_pow_f32_sgpr_sgpr:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    v_mov_b32_e32 v0, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v0
; GFX8-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX8-NEXT:    v_ldexp_f32 v0, s0, v0
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, s1, v0
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    ; return to shader part epilog
;
; GFX9-LABEL: v_pow_f32_sgpr_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, s0, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX9-NEXT:    v_ldexp_f32 v0, s0, v0
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, s1, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    ; return to shader part epilog
;
; GFX10-LABEL: v_pow_f32_sgpr_sgpr:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    v_cmp_gt_f32_e64 s2, 0x800000, s0
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s2
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42000000, s2
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX10-NEXT:    v_ldexp_f32 v0, s0, v0
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, s1, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    ; return to shader part epilog
;
; GFX11-LABEL: v_pow_f32_sgpr_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_cmp_gt_f32_e64 s2, 0x800000, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42000000, s2
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_ldexp_f32 v0, s0, v0
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, s1, v0
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    ; return to shader part epilog
  %pow = call float @llvm.pow.f32(float %x, float %y)
  ret float %pow
}

define float @v_pow_f32_fneg_lhs(float %x, float %y) {
; GFX6-LABEL: v_pow_f32_fneg_lhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e64 vcc, -v0, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e64 v0, -v0, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32_fneg_lhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e64 vcc, -v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, -v0, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32_fneg_lhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e64 vcc, -v0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, -v0, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32_fneg_lhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, 0x800000, -v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s4
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, -v0, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s4
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32_fneg_lhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, 0x800000, -v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_ldexp_f32 v0, -v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, s0
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %neg.x = fneg float %x
  %pow = call float @llvm.pow.f32(float %neg.x, float %y)
  ret float %pow
}

define float @v_pow_f32_fneg_rhs(float %x, float %y) {
; GFX6-LABEL: v_pow_f32_fneg_rhs:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX6-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX6-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_log_f32_e32 v0, v0
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX6-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX6-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX6-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GFX6-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX6-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX6-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX6-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX6-NEXT:    v_exp_f32_e32 v0, v0
; GFX6-NEXT:    v_not_b32_e32 v1, 63
; GFX6-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_pow_f32_fneg_rhs:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: v_pow_f32_fneg_rhs:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX9-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX9-NEXT:    v_log_f32_e32 v0, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX9-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX9-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX9-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX9-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_exp_f32_e32 v0, v0
; GFX9-NEXT:    v_not_b32_e32 v1, 63
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_pow_f32_fneg_rhs:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX10-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX10-NEXT:    v_log_f32_e32 v0, v0
; GFX10-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_legacy_f32_e64 v0, v0, -v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX10-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX10-NEXT:    v_exp_f32_e32 v0, v0
; GFX10-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_pow_f32_fneg_rhs:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_dx9_zero_f32_e64 v0, v0, -v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %neg.y = fneg float %y
  %pow = call float @llvm.pow.f32(float %x, float %neg.y)
  ret float %pow
}

declare half @llvm.pow.f16(half, half)
declare float @llvm.pow.f32(float, float)
declare double @llvm.pow.f64(double, double)

declare half @llvm.fabs.f16(half)
declare float @llvm.fabs.f32(float)

declare <2 x half> @llvm.pow.v2f16(<2 x half>, <2 x half>)
declare <2 x float> @llvm.pow.v2f32(<2 x float>, <2 x float>)
