# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=lunarlake -instruction-tables < %s | FileCheck %s

pabsb       %mm0, %mm2
pabsb       (%rax), %mm2

pabsb       %xmm0, %xmm2
pabsb       (%rax), %xmm2

pabsd       %mm0, %mm2
pabsd       (%rax), %mm2

pabsd       %xmm0, %xmm2
pabsd       (%rax), %xmm2

pabsw       %mm0, %mm2
pabsw       (%rax), %mm2

pabsw       %xmm0, %xmm2
pabsw       (%rax), %xmm2

palignr     $1, %mm0, %mm2
palignr     $1, (%rax), %mm2

palignr     $1, %xmm0, %xmm2
palignr     $1, (%rax), %xmm2

phaddd      %mm0, %mm2
phaddd      (%rax), %mm2

phaddd      %xmm0, %xmm2
phaddd      (%rax), %xmm2

phaddsw     %mm0, %mm2
phaddsw     (%rax), %mm2

phaddsw     %xmm0, %xmm2
phaddsw     (%rax), %xmm2

phaddw      %mm0, %mm2
phaddw      (%rax), %mm2

phaddw      %xmm0, %xmm2
phaddw      (%rax), %xmm2

phsubd      %mm0, %mm2
phsubd      (%rax), %mm2

phsubd      %xmm0, %xmm2
phsubd      (%rax), %xmm2

phsubsw     %mm0, %mm2
phsubsw     (%rax), %mm2

phsubsw     %xmm0, %xmm2
phsubsw     (%rax), %xmm2

phsubw      %mm0, %mm2
phsubw      (%rax), %mm2

phsubw      %xmm0, %xmm2
phsubw      (%rax), %xmm2

pmaddubsw   %mm0, %mm2
pmaddubsw   (%rax), %mm2

pmaddubsw   %xmm0, %xmm2
pmaddubsw   (%rax), %xmm2

pmulhrsw    %mm0, %mm2
pmulhrsw    (%rax), %mm2

pmulhrsw    %xmm0, %xmm2
pmulhrsw    (%rax), %xmm2

pshufb      %mm0, %mm2
pshufb      (%rax), %mm2

pshufb      %xmm0, %xmm2
pshufb      (%rax), %xmm2

psignb      %mm0, %mm2
psignb      (%rax), %mm2

psignb      %xmm0, %xmm2
psignb      (%rax), %xmm2

psignd      %mm0, %mm2
psignd      (%rax), %mm2

psignd      %xmm0, %xmm2
psignd      (%rax), %xmm2

psignw      %mm0, %mm2
psignw      (%rax), %mm2

psignw      %xmm0, %xmm2
psignw      (%rax), %xmm2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                        pabsb	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   pabsb	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        pabsb	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   pabsb	(%rax), %xmm2
# CHECK-NEXT:  1      1     1.00                        pabsd	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   pabsd	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        pabsd	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   pabsd	(%rax), %xmm2
# CHECK-NEXT:  1      1     1.00                        pabsw	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   pabsw	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        pabsw	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   pabsw	(%rax), %xmm2
# CHECK-NEXT:  1      1     0.50                        palignr	$1, %mm0, %mm2
# CHECK-NEXT:  2      9     0.50    *                   palignr	$1, (%rax), %mm2
# CHECK-NEXT:  1      1     0.33                        palignr	$1, %xmm0, %xmm2
# CHECK-NEXT:  2      7     2.00    *                   palignr	$1, (%rax), %xmm2
# CHECK-NEXT:  3      3     1.00                        phaddd	%mm0, %mm2
# CHECK-NEXT:  4      11    1.00    *                   phaddd	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phaddd	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phaddd	(%rax), %xmm2
# CHECK-NEXT:  3      3     0.67                        phaddsw	%mm0, %mm2
# CHECK-NEXT:  4      11    0.67    *                   phaddsw	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phaddsw	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phaddsw	(%rax), %xmm2
# CHECK-NEXT:  3      3     1.00                        phaddw	%mm0, %mm2
# CHECK-NEXT:  4      11    1.00    *                   phaddw	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phaddw	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phaddw	(%rax), %xmm2
# CHECK-NEXT:  3      3     1.00                        phsubd	%mm0, %mm2
# CHECK-NEXT:  4      11    1.00    *                   phsubd	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phsubd	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phsubd	(%rax), %xmm2
# CHECK-NEXT:  3      3     0.67                        phsubsw	%mm0, %mm2
# CHECK-NEXT:  4      11    0.67    *                   phsubsw	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phsubsw	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phsubsw	(%rax), %xmm2
# CHECK-NEXT:  3      3     1.00                        phsubw	%mm0, %mm2
# CHECK-NEXT:  4      11    1.00    *                   phsubw	(%rax), %mm2
# CHECK-NEXT:  3      2     1.00                        phsubw	%xmm0, %xmm2
# CHECK-NEXT:  4      9     1.00    *                   phsubw	(%rax), %xmm2
# CHECK-NEXT:  1      5     0.50                        pmaddubsw	%mm0, %mm2
# CHECK-NEXT:  2      13    0.50    *                   pmaddubsw	(%rax), %mm2
# CHECK-NEXT:  1      4     2.00                        pmaddubsw	%xmm0, %xmm2
# CHECK-NEXT:  1      10    2.00    *                   pmaddubsw	(%rax), %xmm2
# CHECK-NEXT:  1      5     0.50                        pmulhrsw	%mm0, %mm2
# CHECK-NEXT:  2      13    0.50    *                   pmulhrsw	(%rax), %mm2
# CHECK-NEXT:  1      4     2.00                        pmulhrsw	%xmm0, %xmm2
# CHECK-NEXT:  1      10    2.00    *                   pmulhrsw	(%rax), %xmm2
# CHECK-NEXT:  2      3     0.50                        pshufb	%mm0, %mm2
# CHECK-NEXT:  3      11    0.50    *                   pshufb	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        pshufb	%xmm0, %xmm2
# CHECK-NEXT:  2      7     2.00    *                   pshufb	(%rax), %xmm2
# CHECK-NEXT:  1      1     1.00                        psignb	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   psignb	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        psignb	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   psignb	(%rax), %xmm2
# CHECK-NEXT:  1      1     1.00                        psignd	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   psignd	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        psignd	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   psignd	(%rax), %xmm2
# CHECK-NEXT:  1      1     1.00                        psignw	%mm0, %mm2
# CHECK-NEXT:  2      9     1.00    *                   psignw	(%rax), %mm2
# CHECK-NEXT:  1      1     0.50                        psignw	%xmm0, %xmm2
# CHECK-NEXT:  1      7     2.00    *                   psignw	(%rax), %xmm2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - LNLPPort00
# CHECK-NEXT: [1]   - LNLPPort01
# CHECK-NEXT: [2]   - LNLPPort02
# CHECK-NEXT: [3]   - LNLPPort03
# CHECK-NEXT: [4]   - LNLPPort04
# CHECK-NEXT: [5]   - LNLPPort05
# CHECK-NEXT: [6]   - LNLPPort10
# CHECK-NEXT: [7]   - LNLPPort11
# CHECK-NEXT: [8]   - LNLPPort20
# CHECK-NEXT: [9]   - LNLPPort21
# CHECK-NEXT: [10]  - LNLPPort22
# CHECK-NEXT: [11]  - LNLPPort25
# CHECK-NEXT: [12]  - LNLPPort26
# CHECK-NEXT: [13]  - LNLPPort27
# CHECK-NEXT: [14]  - LNLPPortInvalid
# CHECK-NEXT: [15]  - LNLPVPort00
# CHECK-NEXT: [16]  - LNLPVPort01
# CHECK-NEXT: [17]  - LNLPVPort02
# CHECK-NEXT: [18]  - LNLPVPort03

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]
# CHECK-NEXT:  -     3.00    -     3.00    -     3.00    -      -     27.33  27.33  27.33   -      -      -      -     36.50  24.50  28.00  28.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   [13]   [14]   [15]   [16]   [17]   [18]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     pabsb	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     pabsb	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     pabsb	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     pabsb	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     pabsd	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     pabsd	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     pabsd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     pabsd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     pabsw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     pabsw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     pabsw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     pabsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   palignr	$1, %mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     0.50   0.50   palignr	$1, (%rax), %mm2
# CHECK-NEXT:  -     0.33    -     0.33    -     0.33    -      -      -      -      -      -      -      -      -      -      -      -      -     palignr	$1, %xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     0.50   0.50   palignr	$1, (%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phaddd	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phaddd	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phaddd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phaddd	(%rax), %xmm2
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   phaddsw	%mm0, %mm2
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     phaddsw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   1.00   phaddsw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50   1.00   1.00   phaddsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phaddw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phaddw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phaddw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phaddw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phsubd	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phsubd	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phsubd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phsubd	(%rax), %xmm2
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -      -      -      -      -      -      -      -     0.25   0.25   0.25   0.25   phsubsw	%mm0, %mm2
# CHECK-NEXT:  -     0.67    -     0.67    -     0.67    -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     phsubsw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   1.00   1.00   phsubsw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50   1.00   1.00   phsubsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phsubw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phsubw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.25   0.25   1.25   1.25   phsubw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.25   0.25   1.25   1.25   phsubw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     pmaddubsw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     pmaddubsw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -     pmaddubsw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     2.00   2.00    -      -     pmaddubsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     pmulhrsw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50    -      -     pmulhrsw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     2.00   2.00    -      -     pmulhrsw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     2.00   2.00    -      -     pmulhrsw	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   0.50   0.50   pshufb	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     0.50   0.50   0.50   0.50   pshufb	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50   pshufb	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -      -      -     0.50   0.50   pshufb	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     psignb	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     psignb	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     psignb	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     psignb	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     psignd	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     psignd	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     psignd	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     psignd	(%rax), %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     psignw	%mm0, %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     0.33   0.33   0.33    -      -      -      -     1.00    -      -      -     psignw	(%rax), %mm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     0.50   0.50    -      -     psignw	%xmm0, %xmm2
# CHECK-NEXT:  -      -      -      -      -      -      -      -     2.00   2.00   2.00    -      -      -      -     0.50   0.50    -      -     psignw	(%rax), %xmm2
