; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+faminmax -verify-machineinstrs %s -o - | FileCheck %s
; RUN: llc -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK-NO-FAMINMAX

target triple = "aarch64-unknown-linux-gnu"

; Replace min(abs(a), abs(b)) with famin(a, b)
; Replace max(abs(a), abs(b)) with famax(a, b)

; When the fastmath flag 'nnan' (no nan) is enabled, we may also replace:
; minnm(abs(a), abs(b)) with famin(a, b)
; maxnm(abs(a), abs(b)) with famax(a, b)

define <4 x half> @test_max_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_max_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_max_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fmax v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call <4 x half> @llvm.maximum.v4f16(<4 x half> %aa, <4 x half> %ab)
  ret <4 x half> %r
}

define <4 x half> @test_maxnm_nnan_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_maxnm_nnan_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_nnan_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call nnan <4 x half> @llvm.maxnum.v4f16(<4 x half> %aa,  <4 x half> %ab)
  ret <4 x half> %r
}

define <4 x half> @test_maxnm_noflag_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_maxnm_noflag_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4h, v0.4h
; CHECK-NEXT:    fabs v1.4h, v1.4h
; CHECK-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_noflag_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call <4 x half> @llvm.maxnum.v4f16(<4 x half> %aa, <4 x half> %ab)
  ret <4 x half> %r
}

define <4 x half> @test_min_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_min_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fmin v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call <4 x half> @llvm.minimum.v4f16(<4 x half> %aa, <4 x half> %ab)
  ret <4 x half> %r
}

define <4 x half> @test_minnm_nnan_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_minnm_nnan_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_nnan_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call nnan <4 x half> @llvm.minnum.v4f16(<4 x half> %aa, <4 x half> %ab)
  ret <4 x half> %r
}

define <4 x half> @test_minnm_noflag_v4f16(<4 x half> %a, <4 x half> %b) #0 {
; CHECK-LABEL: test_minnm_noflag_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4h, v0.4h
; CHECK-NEXT:    fabs v1.4h, v1.4h
; CHECK-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_noflag_v4f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4h, v0.4h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.4h, v0.4h, v1.4h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x half> @llvm.fabs.v4f16(<4 x half> %a)
  %ab = call <4 x half> @llvm.fabs.v4f16(<4 x half> %b)
  %r = call <4 x half> @llvm.minnum.v4f16(<4 x half> %aa, <4 x half> %ab)
  ret <4 x half> %r
}

define <8 x half> @test_max_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_max_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_max_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fmax v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call <8 x half> @llvm.maximum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <8 x half> @test_maxnm_nnan_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_maxnm_nnan_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_nnan_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call nnan <8 x half> @llvm.maxnum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <8 x half> @test_maxnm_noflag_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_maxnm_noflag_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.8h, v0.8h
; CHECK-NEXT:    fabs v1.8h, v1.8h
; CHECK-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_noflag_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call <8 x half> @llvm.maxnum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <8 x half> @test_min_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_min_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fmin v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call <8 x half> @llvm.minimum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <8 x half> @test_minnm_nnan_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_minnm_nnan_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_nnan_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call nnan <8 x half> @llvm.minnum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <8 x half> @test_minnm_noflag_v8f16(<8 x half> %a, <8 x half> %b) #0 {
; CHECK-LABEL: test_minnm_noflag_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.8h, v0.8h
; CHECK-NEXT:    fabs v1.8h, v1.8h
; CHECK-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_noflag_v8f16:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.8h, v0.8h
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.8h, v0.8h, v1.8h
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <8 x half> @llvm.fabs.v8f16(<8 x half> %a)
  %ab = call <8 x half> @llvm.fabs.v8f16(<8 x half> %b)
  %r = call <8 x half> @llvm.minnum.v8f16(<8 x half> %aa, <8 x half> %ab)
  ret <8 x half> %r
}

define <2 x float> @test_max_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_max_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_max_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fmax v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call <2 x float> @llvm.maximum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <2 x float> @test_maxnm_nnan_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_maxnm_nnan_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_nnan_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call nnan <2 x float> @llvm.maxnum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <2 x float> @test_maxnm_noflag_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_maxnm_noflag_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2s, v0.2s
; CHECK-NEXT:    fabs v1.2s, v1.2s
; CHECK-NEXT:    fmaxnm v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_noflag_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call <2 x float> @llvm.maxnum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <2 x float> @test_min_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_min_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fmin v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call <2 x float> @llvm.minimum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <2 x float> @test_minnm_nnan_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_minnm_nnan_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_nnan_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call nnan <2 x float> @llvm.minnum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <2 x float> @test_minnm_noflag_v2f32(<2 x float> %a, <2 x float> %b) {
; CHECK-LABEL: test_minnm_noflag_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2s, v0.2s
; CHECK-NEXT:    fabs v1.2s, v1.2s
; CHECK-NEXT:    fminnm v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_noflag_v2f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2s, v0.2s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.2s, v0.2s, v1.2s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x float> @llvm.fabs.v2f32(<2 x float> %a)
  %ab = call <2 x float> @llvm.fabs.v2f32(<2 x float> %b)
  %r = call <2 x float> @llvm.minnum.v2f32(<2 x float> %aa, <2 x float> %ab)
  ret <2 x float> %r
}

define <4 x float> @test_max_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_max_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_max_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fmax v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call <4 x float> @llvm.maximum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <4 x float> @test_maxnm_nnan_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_maxnm_nnan_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_nnan_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <4 x float> @test_maxnm_noflag_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_maxnm_noflag_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4s, v0.4s
; CHECK-NEXT:    fabs v1.4s, v1.4s
; CHECK-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_noflag_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call <4 x float> @llvm.maxnum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <4 x float> @test_min_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_min_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fmin v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call <4 x float> @llvm.minimum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <4 x float> @test_minnm_nnan_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_minnm_nnan_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_nnan_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <4 x float> @test_minnm_noflag_v4f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: test_minnm_noflag_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.4s, v0.4s
; CHECK-NEXT:    fabs v1.4s, v1.4s
; CHECK-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_noflag_v4f32:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.4s, v0.4s
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.4s, v0.4s, v1.4s
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <4 x float> @llvm.fabs.v4f32(<4 x float> %a)
  %ab = call <4 x float> @llvm.fabs.v4f32(<4 x float> %b)
  %r = call <4 x float> @llvm.minnum.v4f32(<4 x float> %aa, <4 x float> %ab)
  ret <4 x float> %r
}

define <2 x double> @test_max_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_max_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_max_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fmax v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call <2 x double> @llvm.maximum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

define <2 x double> @test_maxnm_nnan_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_maxnm_nnan_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famax v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_nnan_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call nnan <2 x double> @llvm.maxnum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

define <2 x double> @test_maxnm_noflag_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_maxnm_noflag_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2d, v0.2d
; CHECK-NEXT:    fabs v1.2d, v1.2d
; CHECK-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_maxnm_noflag_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fmaxnm v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call <2 x double> @llvm.maxnum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

define <2 x double> @test_min_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_min_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fmin v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call <2 x double> @llvm.minimum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

define <2 x double> @test_minnm_nnan_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_minnm_nnan_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    famin v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_minnm_nnan_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call nnan <2 x double> @llvm.minnum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

define <2 x double> @test_min_noflag_v2f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_min_noflag_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fabs v0.2d, v0.2d
; CHECK-NEXT:    fabs v1.2d, v1.2d
; CHECK-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
;
; CHECK-NO-FAMINMAX-LABEL: test_min_noflag_v2f64:
; CHECK-NO-FAMINMAX:       // %bb.0:
; CHECK-NO-FAMINMAX-NEXT:    fabs v0.2d, v0.2d
; CHECK-NO-FAMINMAX-NEXT:    fabs v1.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    fminnm v0.2d, v0.2d, v1.2d
; CHECK-NO-FAMINMAX-NEXT:    ret
  %aa = call <2 x double> @llvm.fabs.v2f64(<2 x double> %a)
  %ab = call <2 x double> @llvm.fabs.v2f64(<2 x double> %b)
  %r = call <2 x double> @llvm.minnum.v2f64(<2 x double> %aa, <2 x double> %ab)
  ret <2 x double> %r
}

declare <8 x half> @llvm.fabs.v8f16(<8 x half>)
declare <4 x half> @llvm.fabs.v4f16(<4 x half>)
declare <4 x float> @llvm.fabs.v4f32(<4 x float>)
declare <2 x float> @llvm.fabs.v2f32(<2 x float>)
declare <2 x double> @llvm.fabs.v2f64(<2 x double>)

declare <8 x half> @llvm.minimum.v8f16(<8 x half>, <8 x half>)
declare <4 x half> @llvm.minimum.v4f16(<4 x half>, <4 x half>)
declare <4 x float> @llvm.minimum.v4f32(<4 x float>, <4 x float>)
declare <2 x float> @llvm.minimum.v2f32(<2 x float>, <2 x float>)
declare <2 x double> @llvm.minimum.v2f64(<2 x double>, <2 x double>)

declare <4 x half> @llvm.minnum.v4f16(<4 x half>, <4 x half>)
declare <8 x half> @llvm.minnum.v8f16(<8 x half>, <8 x half>)
declare <2 x float> @llvm.minnum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
declare <2 x double> @llvm.minnum.v2f64(<2 x double>, <2 x double>)

declare <8 x half> @llvm.maximum.v8f16(<8 x half>, <8 x half>)
declare <4 x half> @llvm.maximum.v4f16(<4 x half>, <4 x half>)
declare <4 x float> @llvm.maximum.v4f32(<4 x float>, <4 x float>)
declare <2 x float> @llvm.maximum.v2f32(<2 x float>, <2 x float>)
declare <2 x double> @llvm.maximum.v2f64(<2 x double>, <2 x double>)

declare <4 x half> @llvm.maxnum.v4f16(<4 x half>,  <4 x half>)
declare <8 x half> @llvm.maxnum.v8f16(<8 x half>, <8 x half>)
declare <2 x float> @llvm.maxnum.v2f32(<2 x float>, <2 x float>)
declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
declare <2 x double> @llvm.maxnum.v2f64(<2 x double>, <2 x double>)

attributes #0 = { nounwind "target-features"="+fullfp16" }
