## Unicode Technical Standard #35

# Unicode Locale Data Markup Language (LDML)<br/>Appendix B: Acknowledgments

|Version|48        |
|-------|----------|
|Editors|<a href="tr35-acknowledgments.md#acknowledgments">CLDR committee members|

For the full header, summary, and status, see [Part 1: Core](tr35.md).

### _Summary_

This is a partial document, describing only the acknowledgments of contributors to LDML. For the other parts of the LDML see the [main LDML document](tr35.md) and the links above.

### _Status_

<!-- _This is a draft document which may be updated, replaced, or superseded by other documents at any time.
Publication does not imply endorsement by the Unicode Consortium.
This is not a stable document; it is inappropriate to cite this document as other than a work in progress._ -->

_This document has been reviewed by Unicode members and other interested parties, and has been approved for publication by the Unicode Consortium.
This is a stable document and may be used as reference material or cited as a normative reference by other specifications._

> _**A Unicode Technical Standard (UTS)** is an independent specification. Conformance to the Unicode Standard does not imply conformance to any UTS._

_Please submit corrigenda and other comments with the CLDR bug reporting form [[Bugs](https://cldr.unicode.org/index/bug-reports)].
Related information that is useful in understanding this document is found in the [References](tr35.md#References).
For the latest version of the Unicode Standard see [[Unicode](https://www.unicode.org/versions/latest/)].
For more information see [About Unicode Technical Reports](https://www.unicode.org/reports/about-reports.html) and the [Specifications FAQ](https://www.unicode.org/faq/specifications.html).
Unicode Technical Reports are governed by the Unicode [Terms of Use](https://www.unicode.org/copyright.html)._

## Parts

The LDML specification is divided into the following parts:

*   Part 1: [Core](tr35.md#Contents) (languages, locales, basic structure)
*   Part 2: [General](tr35-general.md#Contents) (display names & transforms, etc.)
*   Part 3: [Numbers](tr35-numbers.md#Contents) (number & currency formatting)
*   Part 4: [Dates](tr35-dates.md#Contents) (date, time, time zone formatting)
*   Part 5: [Collation](tr35-collation.md#Contents) (sorting, searching, grouping)
*   Part 6: [Supplemental](tr35-info.md#Contents) (supplemental data)
*   Part 7: [Keyboards](tr35-keyboards.md#Contents) (keyboard mappings)
*   Part 8: [Person Names](tr35-personNames.md#Contents) (person names)
*   Part 9: [MessageFormat](tr35-messageFormat.md#Contents) (message format)
*   Appendix A: [Modifications](tr35-modifications.md#modifications)
*   Appendix B: [Acknowledgments](tr35-acknowledgments.md#acknowledgments)

## <a name="Contents" href="#Contents">Contents of Appendix B, Acknowledgments</a>

* [Acknowledgments](#acknowledgments)

## Acknowledgments

Special thanks to the following people for their continuing overall contributions to the CLDR project, and for their specific contributions in the following areas. These descriptions only touch on the many contributions that they have made.

* Mark Davis for creating the initial version of LDML, and adding to and maintaining this specification, and for his work on the LDML code and tests, much of the supplemental data and overall structure, and transforms and keyboards.
* John Emmons for the POSIX conversion tool and metazones.
* Deborah Goldsmith for her contributions to LDML architecture and this specification.
* Chris Hansten for coordinating and managing data submissions and vetting.
* Erkki Kolehmainen and his team for their work on Finnish.
* Steven R. Loomis for development of the survey tool and database management.
* Peter Nugent for his contributions to the POSIX tool and from Open Office, and for coordinating and managing data submissions and vetting.
* George Rhoten for his work on currencies.
* Roozbeh Pournader (روزبه پورنادر) for his work on South Asian countries.
* Ram Viswanadha (రఘురామ్ విశ్వనాధ) for all of his work on LDML code and data integration, and for coordinating and managing data submissions and vetting.
* Vladimir Weinstein (Владимир Вајнштајн) for his work on collation.
* Yoshito Umaoka (馬岡 由人) for his work on the timezone architecture.
* Rick McGowan for his work gathering language, script and region data.
* Xiaomei Ji (吉晓梅) for her work on time intervals and plural formatting.
* David Bertoni for his contributions to the conversion tools.
* Mike Tardif for reviewing this specification and for coordinating and vetting data submissions.
* Peter Edberg for work on this specification, monthPatterns, cyclicNameSets, contextTransforms and other items.
* Raymond Wainman and Cibu Johny for their work on keyboards.
* Jennifer Chye for her contributions to the conversion tools.
* Markus Scherer for a major rewrite of Part 5, Collation.
* [Shane Carr](https://www.sffc.xyz/) for his work on numbers and measurement units.
* Robin Leroy for his work on compact plurals: Part 3, [Language Plural Rules](tr35-numbers.md#Language_Plural_Rules)
* Rich Gillam for work on Person Names.
* Alex Kolisnychenko for work on Person Names.
* Mike McKenna for work on Person Names.

* * *

© 2001–2025 Unicode, Inc.
This publication is protected by copyright, and permission must be obtained from Unicode, Inc.
prior to any reproduction, modification, or other use not permitted by the [Terms of Use](https://www.unicode.org/copyright.html).
Specifically, you may make copies of this publication and may annotate and translate it solely for personal or internal business purposes and not for public distribution,
provided that any such permitted copies and modifications fully reproduce all copyright and other legal notices contained in the original.
You may not make copies of or modifications to this publication for public distribution, or incorporate it in whole or in part into any product or publication without the express written permission of Unicode.

Use of all Unicode Products, including this publication, is governed by the Unicode [Terms of Use](https://www.unicode.org/copyright.html).
The authors, contributors, and publishers have taken care in the preparation of this publication,
but make no express or implied representation or warranty of any kind and assume no responsibility or liability for errors or omissions or for consequential or incidental damages that may arise therefrom.
This publication is provided “AS-IS” without charge as a convenience to users.

Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the United States and other countries.
