"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
// The Paulmann 501.41 remote sends a command for when a color temperature
// button is released after having been long-pressed. It sends a 5-byte
// frame. The third byte being set to 0x47 seems to indicate that the
// button long-press is over. When the default parser tries to parse
// the 5-bytes frame, this results in:
//
//   Failed to parse frame: RangeError [ERR_OUT_OF_RANGE]: The value of "offset" is out of range. It must be >= 0 and <= 4. Received 5
//
// Add a custom command parser to work around this.
const fzLocal = {
    paulmann50141ColorTemperatureStopCommand: {
        cluster: "lightingColorCtrl",
        type: "raw",
        convert: (model, msg, publish, options, meta) => {
            if (msg.data.length === 5 && msg.data[2] === 0x47) {
                return {
                    action: "color_temperature_move_stop",
                };
            }
        },
    },
};
exports.definitions = [
    {
        zigbeeModel: ["94842"],
        model: "94842",
        vendor: "Paulmann",
        description: "Outdoor lighting Zigbee motion detector",
        extend: [m.light({ colorTemp: { range: [153, 370] } })],
    },
    {
        zigbeeModel: ["501.37"],
        model: "501.37",
        vendor: "Paulmann",
        description: "Smart switch 4 buttons white",
        fromZigbee: [fz.command_on, fz.command_off, fz.battery, fz.command_move, fz.command_stop],
        toZigbee: [],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "on_2",
                "off_2",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_move_stop_1",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_move_stop_2",
            ]),
        ],
        meta: { multiEndpoint: true },
    },
    {
        zigbeeModel: ["501.34"],
        model: "501.34",
        vendor: "Paulmann",
        description: "Smart switch 4 buttons white",
        fromZigbee: [fz.command_on, fz.command_off, fz.battery, fz.command_move, fz.command_stop],
        toZigbee: [],
        exposes: [
            e.battery(),
            e.action([
                "on_1",
                "off_1",
                "on_2",
                "off_2",
                "brightness_move_up_1",
                "brightness_move_down_1",
                "brightness_stop_1",
                "brightness_move_up_2",
                "brightness_move_down_2",
                "brightness_stop_2",
            ]),
        ],
        meta: { multiEndpoint: true },
    },
    {
        zigbeeModel: ["H036-0500"],
        model: "968.93",
        vendor: "Paulmann",
        description: "URail rail adapter smart home Zigbee on/off/dimm",
        extend: [m.light()],
    },
    {
        fingerprint: [{ modelID: "RGBW", manufacturerName: "Paulmann Licht GmbH" }],
        model: "948.47/29165",
        vendor: "Paulmann",
        description: "RGBW light",
        extend: [m.light({ colorTemp: { range: [153, 500] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        zigbeeModel: ["H036-0007"],
        model: "929.66",
        vendor: "Paulmann",
        description: "Smart home Zigbee LED module coin 1x2.5W RGBW",
        extend: [m.light({ colorTemp: { range: undefined }, color: { modes: ["xy", "hs"] } })],
    },
    {
        zigbeeModel: ["Switch Controller"],
        model: "50043",
        vendor: "Paulmann",
        description: "SmartHome Zigbee Cephei Switch Controller",
        extend: [m.onOff()],
    },
    {
        zigbeeModel: ["50131"],
        model: "501.31",
        vendor: "Paulmann",
        description: "Smart plug for Euro- and Schuko-sockets",
        extend: [m.onOff()],
    },
    {
        zigbeeModel: ["Dimmablelight"],
        model: "50044/50045",
        vendor: "Paulmann",
        description: "SmartHome Zigbee Dimmer or LED-stripe",
        extend: [m.light()],
    },
    {
        fingerprint: [{ modelID: "500.47" }, { modelID: "RGBW", manufacturerName: "Paulmann Licht GmbH", softwareBuildID: "1400-0001" }],
        model: "500.47",
        vendor: "Paulmann",
        description: "SmartHome Zigbee MaxLED RGBW controller",
        extend: [m.light({ colorTemp: { range: [153, 370] }, color: { modes: ["xy", "hs"], enhancedHue: true, applyRedFix: true } })],
    },
    {
        zigbeeModel: ["RGBW light", "500.49", "RGBW_light"],
        model: "50049/500.63",
        vendor: "Paulmann",
        description: "Smart Home Zigbee YourLED RGB Controller max. 60W / Smart Home Zigbee LED Reflektor 3,5W GU10 RGBW dimmbar",
        extend: [m.light({ colorTemp: { range: undefined }, color: { modes: ["xy", "hs"], applyRedFix: true } })],
    },
    {
        zigbeeModel: ["RGBCW_LIGHT"],
        model: "4137",
        vendor: "Paulmann",
        description: "Smart Home Zigbee LED bulb 9,3W Matt E27 RGBW",
        extend: [m.light({ colorTemp: { range: [153, 370] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        fingerprint: [{ modelID: "RGBW Controller", manufacturerName: "Paulmann Licht" }],
        model: "94191",
        vendor: "Paulmann",
        description: "Plug & shine LED strip",
        extend: [m.light({ colorTemp: { range: [153, 370] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        fingerprint: [
            { modelID: "CCT Light", manufacturerName: "Paulmann lamp" },
            { modelID: "CCT", manufacturerName: "Paulmann Licht GmbH" },
        ],
        zigbeeModel: ["CCT light", "CCT_light", "CCT light "],
        model: "50064",
        vendor: "Paulmann",
        description: "SmartHome led spot",
        extend: [m.light({ colorTemp: { range: undefined } })],
    },
    {
        zigbeeModel: ["H036-0006"],
        model: "929.63",
        vendor: "Paulmann",
        description: "SmartHome Zigbee LED-Modul Coin 1x6W Tunable White",
        extend: [m.light({ colorTemp: { range: undefined } })],
    },
    {
        fingerprint: [{ modelID: "CCT", manufacturerName: "Paulmann Licht GmbH", dateCode: "20190515" }],
        zigbeeModel: ["500.46"],
        model: "500.46",
        vendor: "Paulmann",
        description: "SmartHome Zigbee MaxLED tunable white controller max. 144W / 24V DC",
        extend: [m.light({ colorTemp: { range: [153, 370] } })],
    },
    {
        zigbeeModel: ["H036-0005"],
        model: "929.60",
        vendor: "Paulmann",
        description: "SmartHome Zigbee LED-Modul Coin 1x6W White",
        extend: [m.light()],
    },
    {
        fingerprint: [{ modelID: "RGBW", manufacturerName: "Paulmann Licht GmbH", softwareBuildID: "PIIC413" }],
        model: "924.70",
        vendor: "Paulmann",
        description: "LED RGBW+ Module Recessed Light Zigbee Base Coin Single",
        extend: [m.light({ colorTemp: { range: [153, 370] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        zigbeeModel: ["371000001"],
        model: "371000001",
        vendor: "Paulmann",
        description: "SmartHome led spot tuneable white",
        extend: [m.light({ colorTemp: { range: undefined } })],
    },
    {
        fingerprint: [{ modelID: "RGBW", manufacturerName: "Paulmann Licht" }],
        zigbeeModel: ["371000002"],
        model: "371000002",
        vendor: "Paulmann",
        description: "Amaris LED panels",
        extend: [m.light({ colorTemp: { range: undefined }, color: { modes: ["xy", "hs"] } })],
    },
    {
        zigbeeModel: ["371050043"],
        model: "371050043",
        vendor: "Paulmann",
        description: "Solar LED house number light",
        extend: [m.onOff({ powerOnBehavior: false })],
    },
    {
        zigbeeModel: ["371232040"],
        model: "371232040",
        vendor: "Paulmann",
        description: "LED panels",
        extend: [m.light({ colorTemp: { range: [153, 350] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        zigbeeModel: ["500.43"],
        model: "500.43",
        vendor: "Paulmann",
        description: "SmartHome controller (Relay)",
        extend: [m.onOff({ powerOnBehavior: false })],
    },
    {
        zigbeeModel: ["500.44"],
        model: "500.44",
        vendor: "Paulmann",
        description: "URail power supply",
        extend: [m.light({ color: { applyRedFix: true } })],
    },
    {
        zigbeeModel: ["500.45"],
        model: "500.45",
        vendor: "Paulmann",
        description: "SmartHome Zigbee Pendulum Light Aptare",
        extend: [m.light({ color: { applyRedFix: true } })],
    },
    {
        zigbeeModel: ["500.48"],
        model: "500.48",
        vendor: "Paulmann",
        description: "SmartHome Zigbee YourLED dim/switch controller max. 60 W",
        extend: [m.light({ color: { applyRedFix: true } })],
    },
    {
        fingerprint: [{ manufacturerName: "Paulmann Licht GmbH", modelID: "Dimmable" }],
        zigbeeModel: ["H036-0001"],
        model: "93999",
        vendor: "Paulmann",
        description: "Plug Shine Zigbee controller",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["RemoteControl", "50067"],
        model: "500.67",
        vendor: "Paulmann",
        description: "RGB remote control",
        fromZigbee: [
            fz.command_on,
            fz.command_off,
            fz.command_toggle,
            fz.command_step,
            fz.command_move_to_color_temp,
            fz.command_move_to_color,
            fz.command_stop,
            fz.command_move,
            fz.command_color_loop_set,
            fz.command_enhanced_move_to_hue_and_saturation,
            fz.tint_scene,
        ],
        toZigbee: [],
        exposes: [
            e.action([
                "on",
                "off",
                "toggle",
                "brightness_step_up",
                "brightness_step_down",
                "color_temperature_move",
                "color_move",
                "brightness_stop",
                "brightness_move_down",
                "brightness_move_up",
                "color_loop_set",
                "enhanced_move_to_hue_and_saturation",
                "scene_*",
            ]),
        ],
    },
    {
        zigbeeModel: ["501.40", "50140"],
        model: "501.40",
        vendor: "Paulmann",
        description: "RGB remote control",
        extend: [
            m.deviceEndpoints({ endpoints: { "1": 1, "2": 2, "3": 3, "4": 4 } }),
            m.battery(),
            m.commandsOnOff(),
            m.commandsLevelCtrl(),
            m.commandsColorCtrl(),
            m.commandsScenes(),
        ],
    },
    {
        zigbeeModel: ["50141"],
        model: "501.41",
        vendor: "Paulmann",
        description: "Remote control Smart Home Zigbee 3.0 White",
        fromZigbee: [fzLocal.paulmann50141ColorTemperatureStopCommand],
        extend: [
            m.battery({ percentageReporting: false }),
            m.commandsOnOff({
                commands: ["on", "off"],
            }),
            m.commandsLevelCtrl({
                commands: ["brightness_move_up", "brightness_move_down", "brightness_stop", "brightness_step_up", "brightness_step_down"],
            }),
            m.commandsColorCtrl({
                commands: [
                    "color_temperature_move_up",
                    "color_temperature_move_down",
                    "color_temperature_move_stop",
                    "color_temperature_step_up",
                    "color_temperature_step_down",
                ],
            }),
            m.commandsScenes({ commands: ["store", "recall"] }),
        ],
    },
    {
        fingerprint: [{ modelID: "RGB", manufacturerName: "Paulmann Licht GmbH" }],
        model: "150257",
        vendor: "Paulmann",
        description: "SimpLED SmartHome dimmable RGB LED-stripe",
        extend: [m.light({ color: true })],
    },
    {
        fingerprint: [
            { modelID: "Dimmable Light", manufacturerName: "Paulmann lamp" },
            { modelID: "Dimmable Light ", manufacturerName: "Paulmann lamp " },
        ],
        model: "501.22",
        vendor: "Paulmann",
        description: "White E27 LED bulb, dimmable",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["RGBWW"],
        model: "291.52",
        vendor: "Paulmann",
        description: "Smart Home Zigbee LED bulb 4,9W Matt E14 RGBW",
        extend: [m.light({ colorTemp: { range: [153, 454] }, color: { modes: ["xy", "hs"] } })],
    },
    {
        fingerprint: tuya.fingerprint("TS000F", ["_TZ3210_hjxqqofs\u0000"]),
        model: "501.39",
        vendor: "Paulmann",
        description: "Universal-switch white",
        extend: [m.onOff({ powerOnBehavior: false })],
    },
    {
        zigbeeModel: ["371222402"],
        model: "371222402",
        vendor: "Paulmann",
        description: "Puric pane pendant light 6x6W dimmable",
        extend: [m.light()],
    },
    {
        zigbeeModel: ["98442", "98443"],
        model: "984.42",
        vendor: "Paulmann",
        description: "Azalena Smart Home Zigbee LED Light with motion detection (HF)",
        extend: [m.light({ colorTemp: { range: [153, 370] } })],
        whiteLabel: [{ vendor: "Paulmann", model: "984.43", fingerprint: [{ modelID: "98443" }] }],
    },
    {
        zigbeeModel: ["CCT light bulb", "CCT_light_bulb"],
        model: "50394",
        vendor: "Paulmann",
        description: "LED Filament Bulb tuneable white",
        extend: [m.light({ colorTemp: { range: [153, 454] } })],
    },
];
//# sourceMappingURL=paulmann.js.map