"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const exposes = __importStar(require("../lib/exposes"));
const legacy = __importStar(require("../lib/legacy"));
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
const { presets: ep, access: ea } = exposes;
const MINUTES_IN_A_DAY = 1440;
const SECONDS_IN_12_HOURS = 43200;
const exportTemplates = {
    giexWaterValve: {
        vendor: "GIEX",
        description: "Water irrigation valve",
        extend: [tuya.modernExtend.tuyaBase({ forceTimeUpdates: true, timeStart: "1970" })],
        fromZigbee: [legacy.fromZigbee.giexWaterValve],
        toZigbee: [legacy.toZigbee.giexWaterValve],
        exposes: [
            ep.battery(),
            e.binary(legacy.giexWaterValve.state, ea.STATE_SET, "ON", "OFF").withDescription("State"),
            e.enum(legacy.giexWaterValve.mode, ea.STATE_SET, ["duration", "capacity"]).withDescription("Irrigation mode"),
            e
                .numeric(legacy.giexWaterValve.cycleIrrigationNumTimes, ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(100)
                .withDescription("Number of cycle irrigation times, set to 0 for single cycle"),
            e.numeric(legacy.giexWaterValve.irrigationStartTime, ea.STATE).withDescription("Last irrigation start time"),
            e.numeric(legacy.giexWaterValve.irrigationEndTime, ea.STATE).withDescription("Last irrigation end time"),
            e.numeric(legacy.giexWaterValve.lastIrrigationDuration, ea.STATE).withDescription("Last irrigation duration"),
            e.numeric(legacy.giexWaterValve.waterConsumed, ea.STATE).withUnit("L").withDescription("Last irrigation water consumption"),
        ],
    },
};
exports.definitions = [
    // _TZE200_sh1btabb uses minutes, timezone is GMT+8
    {
        ...exportTemplates.giexWaterValve,
        model: "QT06_1",
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_sh1btabb"]),
        exposes: [
            ...exportTemplates.giexWaterValve.exposes,
            e
                .numeric(legacy.giexWaterValve.irrigationTarget, ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(MINUTES_IN_A_DAY)
                .withUnit("minutes or litres")
                .withDescription("Irrigation target, duration in minutes or capacity in litres (depending on mode)"),
            e
                .numeric(legacy.giexWaterValve.cycleIrrigationInterval, ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(MINUTES_IN_A_DAY)
                .withUnit("min")
                .withDescription("Cycle irrigation interval"),
        ],
    },
    // _TZE200_a7sghmms uses seconds, timezone is local
    {
        ...exportTemplates.giexWaterValve,
        model: "QT06_2",
        fingerprint: tuya.fingerprint("TS0601", ["_TZE200_a7sghmms", "_TZE204_a7sghmms", "_TZE204_7ytb3h8u", "_TZE200_7ytb3h8u", "_TZE284_7ytb3h8u"]),
        exposes: [
            ...exportTemplates.giexWaterValve.exposes,
            e
                .numeric(legacy.giexWaterValve.irrigationTarget, ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(SECONDS_IN_12_HOURS)
                .withUnit("seconds or litres")
                .withDescription("Irrigation target, duration in seconds or capacity in litres (depending on mode), " +
                "set to 0 to leave the valve on indefinitely, " +
                "for safety reasons the target will be forced to a minimum of 10 seconds in duration mode"),
            e
                .numeric(legacy.giexWaterValve.cycleIrrigationInterval, ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(SECONDS_IN_12_HOURS)
                .withUnit("sec")
                .withDescription("Cycle irrigation interval"),
        ],
        whiteLabel: [tuya.whitelabel("GIEX", "GX02", "Water valve", ["_TZE204_7ytb3h8u", "_TZE284_7ytb3h8u", "_TZE200_7ytb3h8u"])],
    },
];
//# sourceMappingURL=giex.js.map