/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.pool2.PooledObject;

class AbstractConnectionFactory {
    protected final ConnectionPoolDataSource cpds;
    protected Duration maxConnDuration = Duration.ofMillis(-1L);
    protected final boolean rollbackAfterValidation;
    protected final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();
    protected final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final String validationQuery;
    protected final Duration validationQueryTimeoutDuration;

    AbstractConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, Duration duration, boolean bl) {
        this.cpds = connectionPoolDataSource;
        this.validationQuery = string;
        this.validationQueryTimeoutDuration = duration;
        this.rollbackAfterValidation = bl;
    }

    void setMaxConn(Duration duration) {
        this.maxConnDuration = duration;
    }

    private int toSeconds(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            return 0;
        }
        long l = this.validationQueryTimeoutDuration.getSeconds();
        return l != 0L ? Math.toIntExact(l) : 1;
    }

    protected void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws SQLException {
        Utils.validateLifetime(pooledObject, this.maxConnDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> pooledObject) {
        Connection connection;
        PooledConnection pooledConnection;
        boolean bl;
        block14: {
            try {
                this.validateLifetime(pooledObject);
            }
            catch (Exception exception) {
                return false;
            }
            bl = false;
            pooledConnection = pooledObject.getObject().getPooledConnection();
            connection = null;
            this.validatingSet.add(pooledConnection);
            try {
                int n = this.toSeconds(this.validationQueryTimeoutDuration);
                if (this.validationQuery == null) {
                    try {
                        connection = pooledConnection.getConnection();
                        bl = connection.isValid(n);
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                    break block14;
                }
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    connection = pooledConnection.getConnection();
                    statement = connection.createStatement();
                    if (n > 0) {
                        statement.setQueryTimeout(n);
                    }
                    resultSet = statement.executeQuery(this.validationQuery);
                    bl = resultSet.next();
                    if (this.rollbackAfterValidation) {
                        connection.rollback();
                    }
                    Utils.closeQuietly((AutoCloseable)resultSet);
                }
                catch (Exception exception) {
                    bl = false;
                    break block14;
                }
                Utils.closeQuietly((AutoCloseable)statement);
                break block14;
                finally {
                    Utils.closeQuietly(resultSet);
                    Utils.closeQuietly((AutoCloseable)statement);
                }
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(connection);
                this.validatingSet.remove(pooledConnection);
                throw throwable;
            }
        }
        Utils.closeQuietly((AutoCloseable)connection);
        this.validatingSet.remove(pooledConnection);
        return bl;
    }
}

