/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelToRGBImageFilter_h
#define sitkLabelToRGBImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LabelToRGBImageFilter
\brief Apply a colormap to a label image.

Apply a colormap to a label image. The set of colors is a good selection of distinct colors. The user can choose to use a background value. In that case, a gray pixel with the same intensity than the background label is produced.

This code was contributed in the Insight Journal paper: "The watershed transform in ITK - discussion and new developments" by Beare R., Lehmann G. https://doi.org/10.54294/lf8u75 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France. 


\author Richard Beare. Department of Medicine, Monash University, Melbourne, Australia.


\see LabelOverlayImageFilter 


\see LabelMapToRGBImageFilter , LabelToRGBFunctor, ScalarToRGBPixelFunctor
\sa itk::simple::LabelToRGB for the procedural interface
\sa itk::LabelToRGBImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelToRGBImageFilter : public ImageFilter {
    public:
      using Self = LabelToRGBImageFilter;

      /** Destructor */
      virtual ~LabelToRGBImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelToRGBImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = IntegerPixelIDTypeList;
\

      /**
       * Set/Get the background value
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set/Get the background value
       */
      double GetBackgroundValue() const { return this->m_BackgroundValue; }\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetColormap ( std::vector<uint8_t> Colormap ) { this->m_Colormap = Colormap; return *this; }

      /**
       */
      std::vector<uint8_t> GetColormap() const { return this->m_Colormap; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelToRGBImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_BackgroundValue{0.0};

      std::vector<uint8_t>  m_Colormap{std::vector<uint8_t>()};


      bool m_InPlace{false};
    };

    /**\
     * \brief Apply a colormap to a label image.
     *
     * This function directly calls the execute method of LabelToRGBImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelToRGBImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image LabelToRGB ( Image&& image1, double backgroundValue = 0.0, std::vector<uint8_t> colormap = std::vector<uint8_t>() );
#endif
     SITKBasicFilters_EXPORT Image LabelToRGB ( const Image& image1, double backgroundValue = 0.0, std::vector<uint8_t> colormap = std::vector<uint8_t>() );

     /** @} */
}
#endif
