/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.AbstractFbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FetchResponse;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.SqlResponse;

public class V10Statement
extends AbstractFbWireStatement
implements FbWireStatement {
    private static final int NULL_INDICATOR_NOT_NULL = 0;
    private static final int NULL_INDICATOR_NULL = -1;
    private static final System.Logger log = System.getLogger(V10Statement.class.getName());

    public V10Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected void free(int option) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.doFreePacket(option);
                this.withTransmitLock(OutputStream::flush);
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioWriteError(e);
            }
            try {
                this.processFreeResponse(this.getDatabase().readResponse(this.getStatementWarningCallback()));
            }
            catch (IOException e) {
                this.switchState(StatementState.ERROR);
                throw FbExceptionBuilder.ioReadError(e);
            }
        }
    }

    protected void doFreePacket(int option) throws SQLException, IOException {
        this.sendFree(option);
        this.reset(option == 2);
    }

    protected void sendFree(int option) throws IOException, SQLException {
        this.withTransmitLock(xdrOut -> {
            xdrOut.writeInt(67);
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeInt(option);
        });
    }

    protected void processFreeResponse(Response response) {
    }

    @Override
    public void prepare(String statementText) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            StatementState initialState = this.checkPrepareAllowed();
            this.resetAll();
            if (initialState == StatementState.NEW) {
                this.sendAllocate0();
                this.receiveAllocate0Response();
            } else {
                this.checkStatementValid();
            }
            this.sendPrepare0(statementText);
            this.receivePrepare0Response();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendAllocate0() throws SQLException {
        try {
            this.sendAllocate();
            this.withTransmitLock(OutputStream::flush);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveAllocate0Response() throws SQLException {
        try {
            this.processAllocateResponse(this.getDatabase().readGenericResponse(this.getStatementWarningCallback()));
            this.switchState(StatementState.ALLOCATED);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioReadError(e);
        }
        catch (SQLException e) {
            this.forceState(StatementState.NEW);
            throw e;
        }
    }

    private void sendPrepare0(String statementText) throws SQLException {
        try {
            this.sendPrepare(statementText);
            this.withTransmitLock(OutputStream::flush);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receivePrepare0Response() throws SQLException {
        try {
            this.processPrepareResponse(this.getDatabase().readGenericResponse(this.getStatementWarningCallback()));
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioReadError(e);
        }
        catch (SQLException e) {
            this.switchState(StatementState.ALLOCATED);
            throw e;
        }
    }

    protected void sendPrepare(String statementText) throws SQLException, IOException {
        this.switchState(StatementState.PREPARING);
        this.withTransmitLock(xdrOut -> {
            xdrOut.writeInt(68);
            xdrOut.writeInt(this.getTransaction().getHandle());
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeInt(this.getDatabase().getConnectionDialect());
            xdrOut.writeString(statementText, this.getDatabase().getEncoding());
            xdrOut.writeBuffer(this.getStatementInfoRequestItems());
            xdrOut.writeInt(this.getDefaultSqlInfoSize());
        });
    }

    protected void processPrepareResponse(GenericResponse genericResponse) throws SQLException {
        this.parseStatementInfo(genericResponse.data());
        this.switchState(StatementState.PREPARED);
    }

    @Override
    protected void setCursorNameImpl(String cursorName) throws SQLException {
        try {
            this.withTransmitLock(xdrOut -> {
                xdrOut.writeInt(69);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeString(cursorName + "\u0000", this.getDatabase().getEncoding());
                xdrOut.writeInt(0);
                xdrOut.flush();
            });
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
        try {
            this.getDatabase().readGenericResponse(this.getStatementWarningCallback());
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    @Override
    public void execute(RowValue parameters) throws SQLException {
        StatementState initialState = this.getState();
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            TransactionHelper.checkTransactionActive(this.getTransaction());
            this.validateParameters(parameters);
            this.reset(false);
            this.switchState(StatementState.EXECUTING);
            StatementType statementType = this.getType();
            boolean hasSingletonResult = this.hasSingletonResult();
            int expectedResponseCount = 0;
            try (OperationCloseHandle operationCloseHandle = this.signalExecute();){
                if (operationCloseHandle.isCancelled()) {
                    throw FbExceptionBuilder.toException(335544794);
                }
                try {
                    if (hasSingletonResult) {
                        ++expectedResponseCount;
                    }
                    this.sendExecute(hasSingletonResult ? 76 : 63, parameters);
                    ++expectedResponseCount;
                    this.withTransmitLock(OutputStream::flush);
                }
                catch (IOException e) {
                    this.switchState(StatementState.ERROR);
                    throw FbExceptionBuilder.ioWriteError(e);
                }
                WarningMessageCallback statementWarningCallback = this.getStatementWarningCallback();
                try {
                    FbWireDatabase db = this.getDatabase();
                    try {
                        --expectedResponseCount;
                        Response response = db.readResponse(statementWarningCallback);
                        if (hasSingletonResult) {
                            this.statementListenerDispatcher.statementExecuted(this, false, true);
                            while (response instanceof InlineBlobResponse) {
                                InlineBlobResponse inlineBlobResponse = (InlineBlobResponse)response;
                                this.handleInlineBlobResponse(inlineBlobResponse);
                                response = db.readResponse(statementWarningCallback);
                            }
                            if (response instanceof SqlResponse) {
                                SqlResponse sqlResponse = (SqlResponse)response;
                                this.processExecuteSingletonResponse(sqlResponse);
                                --expectedResponseCount;
                                response = db.readResponse(statementWarningCallback);
                            } else {
                                expectedResponseCount = 0;
                                SQLWarning sqlWarning = new SQLWarning("Expected an SqlResponse, instead received a " + response.getClass().getName());
                                log.log(System.Logger.Level.WARNING, "Unexpected response; see debug level for stacktrace");
                                log.log(System.Logger.Level.DEBUG, "Unexpected response", (Throwable)sqlWarning);
                                statementWarningCallback.processWarning(sqlWarning);
                            }
                            this.setAfterLast();
                        } else {
                            this.statementListenerDispatcher.statementExecuted(this, this.hasFields(), false);
                        }
                        this.processExecuteResponse((GenericResponse)response);
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == 335544794) {
                            expectedResponseCount = 0;
                        }
                        throw e;
                    }
                    finally {
                        db.consumePackets(expectedResponseCount, this.getStatementWarningCallback());
                    }
                    if (this.getState() != StatementState.ERROR) {
                        this.switchState(statementType.isTypeWithCursor() ? StatementState.CURSOR_OPEN : StatementState.PREPARED);
                    }
                }
                catch (IOException e) {
                    this.switchState(StatementState.ERROR);
                    throw FbExceptionBuilder.ioReadError(e);
                }
            }
        }
        catch (SQLException e) {
            if (this.getState() != StatementState.ERROR) {
                this.switchState(initialState);
            }
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void sendExecute(int operation, RowValue parameters) throws IOException, SQLException {
        this.withTransmitLock(xdrOut -> this.sendExecuteMsg(xdrOut, operation, parameters));
    }

    protected void sendExecuteMsg(XdrOutputStream xdrOut, int operation, RowValue parameters) throws IOException, SQLException {
        assert (operation == 63 || operation == 76) : "Needs to be called with operation op_execute or op_execute2";
        xdrOut.writeInt(operation);
        xdrOut.writeInt(this.getHandle());
        xdrOut.writeInt(this.getTransaction().getHandle());
        if (parameters != null && parameters.getCount() > 0) {
            RowDescriptor parameterDescriptor = this.getParameterDescriptor();
            xdrOut.writeBuffer(this.calculateBlr(parameterDescriptor, parameters));
            xdrOut.writeInt(0);
            xdrOut.writeInt(1);
            this.writeSqlData(parameterDescriptor, parameters, true);
        } else {
            xdrOut.writeBuffer(null);
            xdrOut.writeInt(0);
            xdrOut.writeInt(0);
        }
        if (operation == 76) {
            RowDescriptor fieldDescriptor = this.getRowDescriptor();
            xdrOut.writeBuffer(fieldDescriptor != null && fieldDescriptor.getCount() > 0 ? this.calculateBlr(fieldDescriptor) : null);
            xdrOut.writeInt(0);
        }
    }

    protected void processExecuteSingletonResponse(SqlResponse sqlResponse) throws SQLException, IOException {
        if (sqlResponse.count() > 0) {
            this.queueRowData(this.readSqlData());
        }
    }

    protected void processExecuteResponse(GenericResponse genericResponse) {
    }

    @Override
    public void fetchRows(int fetchSize) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementHasOpenCursor();
            this.checkFetchSize(fetchSize);
            if (this.isAfterLast()) {
                return;
            }
            try (OperationCloseHandle operationCloseHandle = this.signalFetch();){
                if (operationCloseHandle.isCancelled()) {
                    throw FbExceptionBuilder.toException(335544794);
                }
                this.sendFetch0(fetchSize);
                this.receiveFetch0Response();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void sendFetch0(int fetchSize) throws SQLException {
        try {
            this.sendFetch(fetchSize);
            this.withTransmitLock(OutputStream::flush);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioWriteError(e);
        }
    }

    private void receiveFetch0Response() throws SQLException {
        try {
            this.processFetchResponse(FetchDirection.FORWARD);
        }
        catch (IOException e) {
            this.switchState(StatementState.ERROR);
            throw FbExceptionBuilder.ioReadError(e);
        }
    }

    protected void processFetchResponse(FetchDirection direction) throws IOException, SQLException {
        this.processFetchResponse(direction, null);
    }

    protected void processFetchResponse(FetchDirection direction, Response response) throws IOException, SQLException {
        int rowsFetched = 0;
        FbWireDatabase database = this.getDatabase();
        WarningMessageCallback statementWarningCallback = this.getStatementWarningCallback();
        if (response == null) {
            response = database.readResponse(statementWarningCallback);
        }
        while (true) {
            if (response instanceof InlineBlobResponse) {
                InlineBlobResponse inlineBlobResponse = (InlineBlobResponse)response;
                this.handleInlineBlobResponse(inlineBlobResponse);
                response = database.readResponse(statementWarningCallback);
                continue;
            }
            if (!(response instanceof FetchResponse)) break;
            FetchResponse fetchResponse = (FetchResponse)response;
            if (fetchResponse.status() == 0 && fetchResponse.count() > 0) {
                this.queueRowData(this.readSqlData());
                ++rowsFetched;
            } else {
                if (fetchResponse.status() == 0 && fetchResponse.count() == 0) break;
                if (fetchResponse.status() == 100) {
                    switch (direction) {
                        case IN_PLACE: {
                            if (this.isBeforeFirst()) {
                                this.setBeforeFirst();
                                break;
                            }
                            this.setAfterLast();
                            break;
                        }
                        case FORWARD: 
                        case UNKNOWN: {
                            this.setAfterLast();
                            break;
                        }
                        case REVERSE: {
                            this.setBeforeFirst();
                        }
                    }
                    break;
                }
                log.log(System.Logger.Level.DEBUG, "Received unexpected fetch response {0}, ignored", fetchResponse);
                break;
            }
            response = database.readResponse(statementWarningCallback);
            if (!(response instanceof FetchResponse) && !(response instanceof InlineBlobResponse)) break;
        }
        this.statementListenerDispatcher.fetchComplete(this, direction, rowsFetched);
    }

    protected void sendFetch(int fetchSize) throws SQLException, IOException {
        this.withTransmitLock(xdrOut -> {
            xdrOut.writeInt(65);
            xdrOut.writeInt(this.getHandle());
            xdrOut.writeBuffer(this.hasFetched() ? null : this.calculateBlr(this.getRowDescriptor()));
            xdrOut.writeInt(0);
            xdrOut.writeInt(fetchSize);
        });
    }

    protected RowValue readSqlData() throws SQLException, IOException {
        RowDescriptor rowDescriptor = this.getRowDescriptor();
        RowValue rowValue = rowDescriptor.createDefaultFieldValues();
        BlrCalculator blrCalculator = this.getBlrCalculator();
        XdrInputStream xdrIn = this.getXdrIn();
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int len = blrCalculator.calculateIoLength(fieldDescriptor);
            byte[] buffer = this.readColumnData(xdrIn, len);
            if (xdrIn.readInt() == -1) {
                buffer = null;
            }
            rowValue.setFieldData(idx, buffer);
        }
        return rowValue;
    }

    protected byte[] readColumnData(XdrInputStream xdrIn, int len) throws IOException {
        if (len == 0) {
            return xdrIn.readBuffer();
        }
        if (len < 0) {
            return xdrIn.readRawBuffer(-len);
        }
        return xdrIn.readBuffer(len - 1);
    }

    protected void writeSqlData(RowDescriptor rowDescriptor, RowValue fieldValues, boolean useActualLength) throws IOException, SQLException {
        this.withTransmitLock(xdrOut -> {
            BlrCalculator blrCalculator = this.getBlrCalculator();
            for (int idx = 0; idx < fieldValues.getCount(); ++idx) {
                FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
                byte[] buffer = fieldValues.getFieldData(idx);
                int len = useActualLength ? blrCalculator.calculateIoLength(fieldDescriptor, buffer) : blrCalculator.calculateIoLength(fieldDescriptor);
                this.writeColumnData(xdrOut, len, buffer, fieldDescriptor);
                xdrOut.writeInt(buffer != null ? 0 : -1);
            }
        });
    }

    protected void writeColumnData(XdrOutputStream xdrOut, int len, byte[] buffer, FieldDescriptor fieldDescriptor) throws IOException {
        if (fieldDescriptor.isFbType(32766)) {
            return;
        }
        if (len == 0) {
            V10Statement.writeLengthPrefixedBuffer(xdrOut, buffer, fieldDescriptor);
        } else if (len < 0) {
            V10Statement.writeFixedLengthBuffer(xdrOut, -len, buffer);
        } else {
            V10Statement.writePaddedBuffer(xdrOut, len - 1, buffer, fieldDescriptor);
        }
    }

    private static void writeLengthPrefixedBuffer(XdrOutputStream xdrOut, byte[] buffer, FieldDescriptor fieldDescriptor) throws IOException {
        if (buffer != null) {
            int len = buffer.length;
            xdrOut.writeInt(len);
            xdrOut.write(buffer, 0, len);
            xdrOut.writePadding(4 - len & 3, fieldDescriptor.getPaddingByte());
        } else {
            xdrOut.writeInt(0);
        }
    }

    private static void writeFixedLengthBuffer(XdrOutputStream xdrOut, int len, byte[] buffer) throws IOException {
        if (buffer != null) {
            xdrOut.write(buffer, 0, len);
        } else {
            xdrOut.writeZeroPadding(len);
        }
    }

    private static void writePaddedBuffer(XdrOutputStream xdrOut, int len, byte[] buffer, FieldDescriptor fieldDescriptor) throws IOException {
        if (buffer != null) {
            int buflen = buffer.length;
            if (buflen >= len) {
                xdrOut.write(buffer, 0, len);
                xdrOut.writePadding(4 - len & 3, fieldDescriptor.getPaddingByte());
            } else {
                xdrOut.write(buffer, 0, buflen);
                xdrOut.writePadding(len - buflen + (4 - len & 3), fieldDescriptor.getPaddingByte());
            }
        } else {
            xdrOut.writePadding(len + (4 - len & 3), fieldDescriptor.getPaddingByte());
        }
    }

    protected void sendAllocate() throws SQLException, IOException {
        this.withTransmitLock(xdrOut -> {
            xdrOut.writeInt(62);
            xdrOut.writeInt(0);
        });
    }

    protected void processAllocateResponse(GenericResponse response) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.setHandle(response.objectHandle());
            this.reset();
            this.setType(StatementType.NONE);
        }
    }

    @Override
    public int getDefaultSqlInfoSize() {
        return this.getMaxSqlInfoSize();
    }

    @Override
    public int getMaxSqlInfoSize() {
        return Short.MAX_VALUE;
    }
}

