/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import us.fatehi.utility.string.StringFormat;

public final class SerializedObjectInputStream
extends ObjectInputStream {
    private static final Logger LOGGER = Logger.getLogger(SerializedObjectInputStream.class.getName());
    private final List<Pattern> acceptClassPatterns;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <C extends Serializable> C read(InputStream in, List<Pattern> acceptClassPatterns) {
        Objects.requireNonNull(in, "No input stream provided");
        try (SerializedObjectInputStream objIn = new SerializedObjectInputStream(in, acceptClassPatterns);){
            Serializable serializable = (Serializable)objIn.readObject();
            return (C)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ExecutionRuntimeException("Cannot deserialize object", e);
        }
    }

    public static <C extends Serializable> void save(C object, OutputStream out) {
        Objects.requireNonNull(object, "No object to serialize provided");
        Objects.requireNonNull(out, "No output stream provided");
        try (ObjectOutputStream objOut = new ObjectOutputStream(out);){
            objOut.writeObject(object);
        }
        catch (IOException e) {
            throw new IORuntimeException("Could not serialize object", e);
        }
    }

    private SerializedObjectInputStream(InputStream input, List<Pattern> acceptClassPatterns) throws IOException {
        super(Objects.requireNonNull(input, "No input stream provided"));
        if (acceptClassPatterns == null || acceptClassPatterns.isEmpty()) {
            throw new IllegalArgumentException("No accept class patterns provided");
        }
        this.acceptClassPatterns = List.copyOf(acceptClassPatterns);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        this.validateClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    private void validateClassName(String className) throws InvalidClassException {
        for (Pattern pattern : this.acceptClassPatterns) {
            if (!pattern.matcher(className).matches()) continue;
            LOGGER.log(Level.FINER, new StringFormat("Deserializing class <%s>", className));
            return;
        }
        throw new InvalidClassException("Not deserializing class <%s>".formatted(className));
    }
}

