/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider;

import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.jdbc.internal.grpc.internal.CertificateUtils;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class CertProviderClientSslContextProvider
extends CertProviderSslContextProvider {
    CertProviderClientSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, upstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext certificateValidationContext) throws CertStoreException {
        XdsTrustManagerFactory trustManagerFactory;
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
        if (this.savedSpiffeTrustMap != null) {
            sslContextBuilder = sslContextBuilder.trustManager(new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContext, this.autoSniSanValidationDoesNotApply ? false : ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation()));
        } else if (this.savedTrustedRoots != null) {
            sslContextBuilder = sslContextBuilder.trustManager(new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContext, this.autoSniSanValidationDoesNotApply ? false : ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation()));
        } else {
            throw new IllegalStateException("There must be trusted roots or a SPIFFE trust map");
        }
        if (this.savedSpiffeTrustMap != null) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContext, ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation());
            sslContextBuilder = sslContextBuilder.trustManager(trustManagerFactory);
        } else {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContext, ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation());
            sslContextBuilder = sslContextBuilder.trustManager(trustManagerFactory);
        }
        if (this.isMtls()) {
            sslContextBuilder.keyManager(this.savedKey, this.savedCertChain);
        }
        return new AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager>(sslContextBuilder, CertificateUtils.getX509ExtendedTrustManager(Arrays.asList(trustManagerFactory.getTrustManagers())));
    }
}

