/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.nio.channels.ReadableByteChannel;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ReadableByteChannelSession;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

final class LazyReadChannel<RBC extends ReadableByteChannel, T> {
    private final Supplier<ReadableByteChannelSession<RBC, T>> sessionSupplier;
    private volatile @MonotonicNonNull ReadableByteChannelSession<RBC, T> session;
    private volatile @MonotonicNonNull RBC channel;
    private boolean open = false;

    LazyReadChannel(Supplier<ReadableByteChannelSession<RBC, T>> sessionSupplier) {
        this.sessionSupplier = sessionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull RBC getChannel() {
        if (this.channel != null) {
            return this.channel;
        }
        LazyReadChannel lazyReadChannel = this;
        synchronized (lazyReadChannel) {
            if (this.channel == null) {
                this.open = true;
                this.channel = this.getSession().open();
            }
            return this.channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull ReadableByteChannelSession<RBC, T> getSession() {
        if (this.session != null) {
            return this.session;
        }
        LazyReadChannel lazyReadChannel = this;
        synchronized (lazyReadChannel) {
            if (this.session == null) {
                this.session = this.sessionSupplier.get();
            }
            return this.session;
        }
    }

    boolean isOpen() {
        return this.open && this.getChannel().isOpen();
    }
}

