/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.internal.core.minicore;

import com.sun.jna.Native;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.internal.core.minicore.MinicoreLibrary;
import net.snowflake.client.internal.core.minicore.MinicoreLoadLogger;
import net.snowflake.client.internal.core.minicore.MinicoreLoadResult;
import net.snowflake.client.internal.core.minicore.MinicorePlatform;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class MinicoreLoader {
    private static final SFLogger logger = SFLoggerFactory.getLogger(MinicoreLoader.class);
    private static final String TEMP_DIR_PREFIX = "snowflake-minicore-";
    private MinicoreLoadResult loadResult;
    private final MinicoreLoadLogger loadLogger = new MinicoreLoadLogger();
    private final MinicorePlatform platform = new MinicorePlatform();

    public synchronized MinicoreLoadResult loadLibrary() {
        if (this.loadResult != null) {
            return this.loadResult;
        }
        this.loadLogger.log("Starting minicore loading");
        this.loadLogger.log("Detected platform: OS=" + this.platform.getOsName() + ", Arch=" + this.platform.getOsArch());
        if (!this.platform.isSupported()) {
            this.loadLogger.log("Platform not supported");
            this.loadResult = this.failure("Unsupported platform: OS=" + this.platform.getOsName() + ", Arch=" + this.platform.getOsArch(), null);
            return this.loadResult;
        }
        this.loadLogger.log("Platform supported: " + this.platform.getPlatformIdentifier());
        this.loadResult = this.loadFromJar();
        return this.loadResult;
    }

    private MinicoreLoadResult loadFromJar() {
        String resourcePath = this.platform.getLibraryPath();
        this.loadLogger.log("Library resource path: " + resourcePath);
        byte[] libraryBytes = this.readLibraryFromJar(resourcePath);
        if (libraryBytes == null) {
            return this.failure("Library resource not found in JAR: " + resourcePath, null);
        }
        MinicoreLoadResult result = this.tryDirectory("temp", libraryBytes, this::createTempDirectory);
        if (result != null) {
            return result;
        }
        result = this.tryDirectory("home cache", libraryBytes, this::getOrCreateHomeCacheDirectory);
        if (result != null) {
            return result;
        }
        result = this.tryDirectory("working", libraryBytes, this::getWorkingDirectory);
        if (result != null) {
            return result;
        }
        this.loadLogger.log("No writable directory found");
        return this.failure("No writable directory found (tried: temp, home cache, working dir)", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readLibraryFromJar(String resourcePath) {
        try (InputStream stream = MinicoreLoader.class.getResourceAsStream(resourcePath);){
            if (stream == null) {
                this.loadLogger.log("Library resource not found in JAR");
                byte[] byArray2 = null;
                return byArray2;
            }
            this.loadLogger.log("Library resource found in JAR");
            byte[] byArray = IOUtils.toByteArray(stream);
            return byArray;
        }
        catch (IOException e) {
            this.loadLogger.log("Failed to read library from JAR: " + e.getMessage());
            return null;
        }
    }

    private MinicoreLoadResult tryDirectory(String name, byte[] libraryBytes, DirectorySupplier supplier) {
        Path targetPath = null;
        Path createdTempDir = null;
        try {
            Path directory = supplier.get();
            if (directory == null) {
                return null;
            }
            if (directory.toString().startsWith(System.getProperty("java.io.tmpdir"))) {
                createdTempDir = directory;
            }
            targetPath = directory.resolve(this.platform.getLibraryFileName());
            this.loadLogger.log("Trying " + name + " directory: " + directory);
            return this.writeLoadAndCleanup(targetPath, libraryBytes);
        }
        catch (Exception e) {
            this.loadLogger.log("Failed to use " + name + " directory: " + e.getMessage());
            this.cleanup(targetPath, createdTempDir);
            return null;
        }
    }

    private Path createTempDirectory() throws IOException {
        Path tempDir = Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]);
        this.setDirectoryPermissions(tempDir);
        return tempDir;
    }

    private Path getOrCreateHomeCacheDirectory() throws IOException {
        Path cacheDir = this.getHomeCacheDirectory();
        if (cacheDir == null) {
            return null;
        }
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            Files.createDirectories(cacheDir, new FileAttribute[0]);
        }
        this.setDirectoryPermissions(cacheDir);
        return cacheDir;
    }

    private Path getWorkingDirectory() {
        String cwd = System.getProperty("user.dir");
        return cwd != null && !cwd.isEmpty() ? Paths.get(cwd, new String[0]) : null;
    }

    Path getHomeCacheDirectory() {
        String home = System.getProperty("user.home");
        if (home == null || home.isEmpty()) {
            return null;
        }
        switch (this.platform.getOs()) {
            case WINDOWS: {
                return Paths.get(home, "AppData", "Local", "Snowflake", "Caches", "minicore");
            }
            case MAC: {
                return Paths.get(home, "Library", "Caches", "Snowflake", "minicore");
            }
        }
        return Paths.get(home, ".cache", "Snowflake", "minicore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MinicoreLoadResult writeLoadAndCleanup(Path targetPath, byte[] libraryBytes) throws IOException {
        Files.write(targetPath, libraryBytes, new OpenOption[0]);
        this.loadLogger.log("Wrote library to: " + targetPath);
        this.setFilePermissions(targetPath);
        try {
            this.loadLogger.log("Loading library");
            MinicoreLibrary library = (MinicoreLibrary)Native.load((String)targetPath.toAbsolutePath().toString(), MinicoreLibrary.class);
            this.loadLogger.log("Library loaded successfully");
            MinicoreLoadResult minicoreLoadResult = this.getVersionAndCreateResult(library);
            return minicoreLoadResult;
        }
        finally {
            this.deleteQuietly(targetPath);
            this.loadLogger.log("Deleted library file");
        }
    }

    private MinicoreLoadResult getVersionAndCreateResult(MinicoreLibrary library) {
        try {
            String version = library.sf_core_full_version();
            this.loadLogger.log("Library version: " + version);
            return MinicoreLoadResult.success(this.platform.getLibraryFileName(), library, version, this.loadLogger.getLogs());
        }
        catch (UnsatisfiedLinkError e) {
            this.loadLogger.log("Library missing sf_core_full_version symbol: " + e.getMessage());
            return this.failure("Library missing required symbol: sf_core_full_version", e);
        }
        catch (Exception e) {
            this.loadLogger.log("Failed to get library version: " + e.getMessage());
            return this.failure("Failed to get library version: " + e.getMessage(), e);
        }
    }

    private void cleanup(Path filePath, Path tempDirectory) {
        this.deleteQuietly(filePath);
        this.deleteQuietly(tempDirectory);
    }

    private void deleteQuietly(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException e) {
            logger.trace("Failed to delete: {}", e.getMessage());
        }
    }

    private MinicoreLoadResult failure(String message, Throwable cause) {
        return MinicoreLoadResult.failure(message, this.platform.getLibraryFileName(), cause, this.loadLogger.getLogs());
    }

    private void setDirectoryPermissions(Path path) throws IOException {
        this.setPermissions(path, true);
    }

    private void setFilePermissions(Path path) throws IOException {
        this.setPermissions(path, false);
    }

    private void setPermissions(Path path, boolean executable) throws IOException {
        if (this.platform.getOs() == Constants.OS.WINDOWS) {
            path.toFile().setReadable(true, true);
            path.toFile().setWritable(true, true);
            path.toFile().setExecutable(executable, true);
        } else {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            if (executable) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            Files.setPosixFilePermissions(path, perms);
        }
    }

    @FunctionalInterface
    private static interface DirectorySupplier {
        public Path get() throws IOException;
    }
}

