/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.internal.core.minicore;

import com.sun.jna.Platform;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.internal.core.minicore.LibC;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class LibcDetector {
    private static final SFLogger logger = SFLoggerFactory.getLogger(LibcDetector.class);

    public static LibcVariant detectLibcVariant() {
        if (!Platform.isLinux()) {
            return LibcVariant.UNSUPPORTED;
        }
        if (LibC.INSTANCE == null) {
            logger.trace("Failed to load C library, cannot detect libc variant", new Object[0]);
            return LibcVariant.UNSUPPORTED;
        }
        try {
            String version = LibC.INSTANCE.gnu_get_libc_version();
            logger.trace("Successfully called gnu_get_libc_version(), version: {}", version);
            return LibcVariant.GLIBC;
        }
        catch (UnsatisfiedLinkError e) {
            logger.trace("gnu_get_libc_version() not found, detected musl: {}", e.getMessage());
            return LibcVariant.MUSL;
        }
        catch (Throwable t2) {
            logger.trace("Error calling gnu_get_libc_version(): {}", t2.getMessage());
            return LibcVariant.UNSUPPORTED;
        }
    }

    public static enum LibcVariant {
        GLIBC("glibc"),
        MUSL("musl"),
        UNSUPPORTED("unsupported");

        private final String identifier;

        private LibcVariant(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

