/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public final class IOUtility {
    private static final Logger LOGGER = Logger.getLogger(IOUtility.class.getName());

    public static URL locateResource(String classpathResource) {
        URL url;
        URL url2;
        if (classpathResource == null || classpathResource.isBlank()) {
            return null;
        }
        String resolvedClasspathResource = classpathResource.startsWith("/") ? classpathResource.substring(1) : classpathResource;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && (url2 = contextClassLoader.getResource(resolvedClasspathResource)) != null) {
            return url2;
        }
        ClassLoader classClassLoader = IOUtility.class.getClassLoader();
        if (classClassLoader != null && (url = classClassLoader.getResource(resolvedClasspathResource)) != null) {
            return url;
        }
        return IOUtility.class.getResource("/" + resolvedClasspathResource);
    }

    public static InputStream newResourceInputStream(String classpathResource) {
        URL url = IOUtility.locateResource(classpathResource);
        if (url == null) {
            IOUtility.throwForBadResource(classpathResource);
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (IOException e) {
            IOUtility.throwForBadResource(classpathResource);
        }
        if (inputStream == null) {
            IOUtility.throwForBadResource(classpathResource);
        }
        return inputStream;
    }

    public static BufferedReader newResourceReader(String classpathResource) {
        InputStream inputStream = IOUtility.newResourceInputStream(classpathResource);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return reader;
    }

    private static void throwForBadResource(String classpathResource) {
        IllegalArgumentException e = new IllegalArgumentException("Cannot read classpath resource, <%s>".formatted(classpathResource));
        throw e;
    }

    private IOUtility() {
    }
}

