/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.jdbc.metadata.MetadataPatternMatcher;

public class GetSchemas {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(2, DbMetadataMediator.datatypeCoder).at(0).simple(448, 63, "TABLE_SCHEM", "TABLESCHEMAS").addField().at(1).simple(449, 63, "TABLE_CATALOG", "TABLESCHEMAS").addField().toRowDescriptor();

    private GetSchemas() {
    }

    public ResultSet getSchemas(String schemaPattern) throws SQLException {
        return new FBResultSet(ROW_DESCRIPTOR, Collections.emptyList());
    }

    public static GetSchemas create(DbMetadataMediator mediator) {
        if ("OOREMOTE".equals(mediator.getGDSType().toString())) {
            return new OO();
        }
        return new GetSchemas();
    }

    private static final class OO
    extends GetSchemas {
        private static final String DEFAULT_SCHEMA = "DEFAULT";

        private OO() {
        }

        @Override
        public ResultSet getSchemas(String schemaPattern) throws SQLException {
            MetadataPatternMatcher matcher = MetadataPattern.compile(schemaPattern).toMetadataPatternMatcher();
            List<RowValue> rows = matcher.matches(DEFAULT_SCHEMA) ? Collections.singletonList(RowValue.of(ROW_DESCRIPTOR, (byte[][])new byte[][]{DbMetadataMediator.datatypeCoder.encodeString(DEFAULT_SCHEMA), null})) : Collections.emptyList();
            return new FBResultSet(ROW_DESCRIPTOR, rows);
        }
    }
}

