/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.props.def;

import org.firebirdsql.jaybird.props.DpbType;
import org.firebirdsql.jaybird.props.internal.TransactionNameMapping;

public enum ConnectionPropertyType {
    STRING(DpbType.STRING){

        @Override
        public String toType(String stringValue) {
            return stringValue;
        }

        @Override
        public String toType(Integer intValue) {
            return intValue != null ? String.valueOf(intValue) : null;
        }

        @Override
        public String toType(Boolean booleanValue) {
            return booleanValue != null ? String.valueOf(booleanValue) : null;
        }

        @Override
        public Integer asInteger(Object value) {
            return (Integer)INT.toType((String)value);
        }

        @Override
        public Boolean asBoolean(Object value) {
            return (Boolean)BOOLEAN.toType((String)value);
        }
    }
    ,
    INT(DpbType.INT){

        @Override
        public Integer toType(String stringValue) {
            return stringValue != null ? Integer.valueOf(stringValue) : null;
        }

        @Override
        public Integer toType(Integer intValue) {
            return intValue;
        }

        @Override
        public Integer toType(Boolean booleanValue) {
            return booleanValue != null ? Integer.valueOf(booleanValue != false ? 1 : 0) : null;
        }

        @Override
        public Integer asInteger(Object value) {
            return (Integer)value;
        }

        @Override
        public Boolean asBoolean(Object value) {
            return (Boolean)BOOLEAN.toType((Integer)value);
        }
    }
    ,
    BOOLEAN(DpbType.SINGLE){

        @Override
        public Boolean toType(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            if (stringValue.isEmpty()) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf(stringValue);
        }

        @Override
        public Boolean toType(Integer intValue) {
            if (intValue == null) {
                return null;
            }
            if (intValue == 0) {
                return false;
            }
            if (intValue == 1) {
                return true;
            }
            throw new IllegalArgumentException("Cannot convert integer other than null, 0 or 1 to boolean");
        }

        @Override
        public Boolean toType(Boolean booleanValue) {
            return booleanValue;
        }

        @Override
        public Integer asInteger(Object value) {
            return (Integer)INT.toType((Boolean)value);
        }

        @Override
        public Boolean asBoolean(Object value) {
            return (Boolean)value;
        }
    }
    ,
    TRANSACTION_ISOLATION(DpbType.NONE){

        @Override
        public Object toType(String stringValue) {
            if (stringValue == null) {
                return null;
            }
            return TransactionNameMapping.toIsolationLevel(stringValue);
        }

        @Override
        public Object toType(Integer intValue) {
            return intValue;
        }

        @Override
        public Object toType(Boolean booleanValue) {
            if (booleanValue == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert Boolean to transaction isolation");
        }

        @Override
        public String asString(Object value) {
            if (value == null) {
                return null;
            }
            return TransactionNameMapping.toIsolationLevelName((Integer)value, true);
        }

        @Override
        public Integer asInteger(Object value) {
            return (Integer)value;
        }

        @Override
        public Boolean asBoolean(Object value) {
            if (value == null) {
                return null;
            }
            throw new IllegalArgumentException("Cannot convert transaction isolation to Boolean");
        }
    };

    private final DpbType defaultDpbType;

    private ConnectionPropertyType(DpbType defaultDpbType) {
        this.defaultDpbType = defaultDpbType;
    }

    public final DpbType getDefaultParameterType() {
        return this.defaultDpbType;
    }

    public abstract Object toType(String var1);

    public abstract Object toType(Integer var1);

    public abstract Object toType(Boolean var1);

    public abstract Integer asInteger(Object var1);

    public String asString(Object value) {
        return value != null ? String.valueOf(value) : null;
    }

    public abstract Boolean asBoolean(Object var1);
}

